"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogDrivers = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_log_driver_1 = require("./aws-log-driver");
const firelens_log_driver_1 = require("./firelens-log-driver");
const fluentd_log_driver_1 = require("./fluentd-log-driver");
const gelf_log_driver_1 = require("./gelf-log-driver");
const journald_log_driver_1 = require("./journald-log-driver");
const json_file_log_driver_1 = require("./json-file-log-driver");
const splunk_log_driver_1 = require("./splunk-log-driver");
const syslog_log_driver_1 = require("./syslog-log-driver");
/**
 * The base class for log drivers.
 *
 * @stability stable
 */
class LogDrivers {
    /**
     * Creates a log driver configuration that sends log information to CloudWatch Logs.
     *
     * @stability stable
     */
    static awsLogs(props) {
        return new aws_log_driver_1.AwsLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to fluentd Logs.
     *
     * @stability stable
     */
    static fluentd(props) {
        return new fluentd_log_driver_1.FluentdLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to gelf Logs.
     *
     * @stability stable
     */
    static gelf(props) {
        return new gelf_log_driver_1.GelfLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to journald Logs.
     *
     * @stability stable
     */
    static journald(props) {
        return new journald_log_driver_1.JournaldLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to json-file Logs.
     *
     * @stability stable
     */
    static jsonFile(props) {
        return new json_file_log_driver_1.JsonFileLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to splunk Logs.
     *
     * @stability stable
     */
    static splunk(props) {
        return new splunk_log_driver_1.SplunkLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to syslog Logs.
     *
     * @stability stable
     */
    static syslog(props) {
        return new syslog_log_driver_1.SyslogLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to firelens log router.
     *
     * For detail configurations, please refer to Amazon ECS FireLens Examples:
     * https://github.com/aws-samples/amazon-ecs-firelens-examples
     *
     * @stability stable
     */
    static firelens(props) {
        return new firelens_log_driver_1.FireLensLogDriver(props);
    }
}
exports.LogDrivers = LogDrivers;
_a = JSII_RTTI_SYMBOL_1;
LogDrivers[_a] = { fqn: "@aws-cdk/aws-ecs.LogDrivers", version: "1.106.0" };
//# sourceMappingURL=data:application/json;base64,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