import { SecretValue } from '@aws-cdk/core';
import { ContainerDefinition } from '../container-definition';
import { BaseLogDriverProps } from './base-log-driver';
import { LogDriver, LogDriverConfig } from './log-driver';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Log Message Format.
 *
 * @stability stable
 */
export declare enum SplunkLogFormat {
    /**
     * @stability stable
     */
    INLINE = "inline",
    /**
     * @stability stable
     */
    JSON = "json",
    /**
     * @stability stable
     */
    RAW = "raw"
}
/**
 * Specifies the splunk log driver configuration options.
 *
 * [Source](https://docs.docker.com/config/containers/logging/splunk/)
 *
 * @stability stable
 */
export interface SplunkLogDriverProps extends BaseLogDriverProps {
    /**
     * Splunk HTTP Event Collector token.
     *
     * @stability stable
     */
    readonly token: SecretValue;
    /**
     * Path to your Splunk Enterprise, self-service Splunk Cloud instance, or Splunk Cloud managed cluster (including port and scheme used by HTTP Event Collector) in one of the following formats: https://your_splunk_instance:8088 or https://input-prd-p-XXXXXXX.cloud.splunk.com:8088 or https://http-inputs-XXXXXXXX.splunkcloud.com.
     *
     * @stability stable
     */
    readonly url: string;
    /**
     * Event source.
     *
     * @default - source not set.
     * @stability stable
     */
    readonly source?: string;
    /**
     * Event source type.
     *
     * @default - sourceType not set.
     * @stability stable
     */
    readonly sourceType?: string;
    /**
     * Event index.
     *
     * @default - index not set.
     * @stability stable
     */
    readonly index?: string;
    /**
     * Path to root certificate.
     *
     * @default - caPath not set.
     * @stability stable
     */
    readonly caPath?: string;
    /**
     * Name to use for validating server certificate.
     *
     * @default - The hostname of the splunk-url
     * @stability stable
     */
    readonly caName?: string;
    /**
     * Ignore server certificate validation.
     *
     * @default - insecureSkipVerify not set.
     * @stability stable
     */
    readonly insecureSkipVerify?: string;
    /**
     * Message format.
     *
     * Can be inline, json or raw.
     *
     * @default - inline
     * @stability stable
     */
    readonly format?: SplunkLogFormat;
    /**
     * Verify on start, that docker can connect to Splunk server.
     *
     * @default - true
     * @stability stable
     */
    readonly verifyConnection?: boolean;
    /**
     * Enable/disable gzip compression to send events to Splunk Enterprise or Splunk Cloud instance.
     *
     * @default - false
     * @stability stable
     */
    readonly gzip?: boolean;
    /**
     * Set compression level for gzip.
     *
     * Valid values are -1 (default), 0 (no compression),
     * 1 (best speed) ... 9 (best compression).
     *
     * @default - -1 (Default Compression)
     * @stability stable
     */
    readonly gzipLevel?: number;
}
/**
 * A log driver that sends log information to splunk Logs.
 *
 * @stability stable
 */
export declare class SplunkLogDriver extends LogDriver {
    private readonly props;
    /**
     * Constructs a new instance of the SplunkLogDriver class.
     *
     * @param props the splunk log driver configuration options.
     * @stability stable
     */
    constructor(props: SplunkLogDriverProps);
    /**
     * Called when the log driver is configured on a container.
     *
     * @stability stable
     */
    bind(_scope: CoreConstruct, _containerDefinition: ContainerDefinition): LogDriverConfig;
}
