"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.joinWithCommas = exports.renderCommonLogDriverOptions = exports.stringifyOptions = exports.ensureInRange = exports.ensurePositiveInteger = exports.removeEmpty = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * Remove undefined values from a dictionary
 */
function removeEmpty(x) {
    for (const key of Object.keys(x)) {
        if (x[key] === undefined) {
            delete x[key];
        }
    }
    return x;
}
exports.removeEmpty = removeEmpty;
/**
 * Checks that a value is a positive integer
 */
function ensurePositiveInteger(val) {
    if (!core_1.Token.isUnresolved(val) && Number.isInteger(val) && val < 0) {
        throw new Error(`\`${val}\` must be a positive integer.`);
    }
}
exports.ensurePositiveInteger = ensurePositiveInteger;
/**
 * Checks that a value is contained in a range of two other values
 */
function ensureInRange(val, start, end) {
    if (!core_1.Token.isUnresolved(val) && !(val >= start && val <= end)) {
        throw new Error(`\`${val}\` must be within range ${start}:${end}`);
    }
}
exports.ensureInRange = ensureInRange;
function stringifyOptions(options) {
    const _options = {};
    const filteredOptions = removeEmpty(options);
    for (const key of Object.keys(filteredOptions)) {
        // Convert value to string
        _options[key] = `${filteredOptions[key]}`;
    }
    return _options;
}
exports.stringifyOptions = stringifyOptions;
function renderCommonLogDriverOptions(opts) {
    return {
        'tag': opts.tag,
        'labels': joinWithCommas(opts.labels),
        'env': joinWithCommas(opts.env),
        'env-regex': opts.envRegex,
    };
}
exports.renderCommonLogDriverOptions = renderCommonLogDriverOptions;
function joinWithCommas(xs) {
    return xs && xs.join(',');
}
exports.joinWithCommas = joinWithCommas;
//# sourceMappingURL=data:application/json;base64,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