"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppMeshProxyConfiguration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const proxy_configuration_1 = require("./proxy-configuration");
/**
 * The class for App Mesh proxy configurations.
 *
 * For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container agent and at least version
 * 1.26.0-1 of the ecs-init package to enable a proxy configuration. If your container instances are launched from the Amazon ECS-optimized
 * AMI version 20190301 or later, then they contain the required versions of the container agent and ecs-init.
 * For more information, see [Amazon ECS-optimized AMIs](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html).
 *
 * For tasks using the Fargate launch type, the task or service requires platform version 1.3.0 or later.
 *
 * @stability stable
 */
class AppMeshProxyConfiguration extends proxy_configuration_1.ProxyConfiguration {
    /**
     * Constructs a new instance of the AppMeshProxyConfiguration class.
     *
     * @stability stable
     */
    constructor(props) {
        super();
        this.props = props;
        if (props.properties) {
            if (!props.properties.ignoredUID && !props.properties.ignoredGID) {
                throw new Error('At least one of ignoredUID or ignoredGID should be specified.');
            }
        }
    }
    /**
     * Called when the proxy configuration is configured on a task definition.
     *
     * @stability stable
     */
    bind(_scope, _taskDefinition) {
        const configProps = this.props.properties;
        const configType = 'APPMESH';
        return {
            containerName: this.props.containerName,
            proxyConfigurationProperties: renderProperties(configProps),
            type: configType,
        };
    }
}
exports.AppMeshProxyConfiguration = AppMeshProxyConfiguration;
_a = JSII_RTTI_SYMBOL_1;
AppMeshProxyConfiguration[_a] = { fqn: "@aws-cdk/aws-ecs.AppMeshProxyConfiguration", version: "1.106.0" };
function renderProperties(props) {
    const ret = new Array();
    for (const [k, v] of Object.entries(props)) {
        const key = String(k);
        const value = String(v);
        if (value !== 'undefined' && value !== '') {
            const capitalizedKey = key.charAt(0).toUpperCase() + key.slice(1);
            ret.push({ ['name']: capitalizedKey, ['value']: value });
        }
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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