import { TaskDefinition } from '../base/task-definition';
import { CfnTaskDefinition } from '../ecs.generated';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * The base class for proxy configurations.
 *
 * @stability stable
 */
export declare abstract class ProxyConfiguration {
    /**
     * Called when the proxy configuration is configured on a task definition.
     *
     * @stability stable
     */
    abstract bind(_scope: CoreConstruct, _taskDefinition: TaskDefinition): CfnTaskDefinition.ProxyConfigurationProperty;
}
