# dbt-autofix

dbt-autofix automatically scans your dbt project for deprecated configurations and updates them to align with the latest best practices. This makes it easier to resolve deprecation warnings introduced in dbt v1.10 as well as prepare for migration to the dbt Fusion engine.


## Deprecation Coverage - Project Files

The following deprecations are covered by `dbt-autofix deprecations`:

| Deprecation Code in dbt Core      | Files             | Handling                                                                                         | Support | Behavior Change |
| --------------------------------- | ----------------- | ------------------------------------------------------------------------------------------------ | ------- | --------------- |
| `PropertyMovedToConfigDeprecation`    | YAML files        | Move all deprecated property-level configs under `config:` in YAML files across all resource types (models, exposures, owners, etc)      |   Full  | No |
| `CustomKeyInObjectDeprecation`    | YAML files        | Move all models extra config (not valid or custom) under `meta:` and `meta` under `config:`      |   Full  | No |
| `DuplicateYAMLKeysDeprecation`    | YAML files        | Remove duplicate keys in YAML files, keeping the second one to keep the same behaviour           |   Full  | No |
| `UnexpectedJinjaBlockDeprecation` | SQL files         | Remove extra `{% endmacro %}` and `{% endif %}` that don't have corresponding opening statements |   Full  | No |
| `MissingPlusPrefixDeprecation` | `dbt_project.yml` | Prefix all built-in configs for models/tests etc... with a `+`                                     | Partial (Does not yet prefix custom configs) | No |
| `ConfigDataPathDeprecation`       | `dbt_project.yml` | Remove deprecated config for data path (now seed)                                                |   Full  | No |
| `ConfigLogPathDeprecation`        | `dbt_project.yml` | Remove deprecated config for log path                                                            |   Full  | No |
| `ConfigSourcePathDeprecation`     | `dbt_project.yml` | Remove deprecated config for source path                                                         |   Full  | No |
| `ConfigTargetPathDeprecation`     | `dbt_project.yml` | Remove deprecated config for target path                                                         |   Full  | No |
| `ExposureNameDeprecation` | YAML files | Replaces spaces with underscores in exposure names | Full | Yes |
| `ResourceNamesWithSpacesDeprecation` | SQL files, YAML files | Replaces spaces with underscores in resource names, updating .sql filenames as necessary | Full | Yes |  
| `SourceFreshnessProjectHooksNotRun` | `dbt_project.yml` | Set `source_freshness_run_project_hooks` in `dbt_project.yml` "flags" to true | Full | Yes |

## Deprecation Coverage - CLI Commands

The following deprecations are covered by `dbt-autofix jobs`:

| Deprecation Code in dbt                        | Handling                              | Support | Behavior Change |
| ---------------------------------------------- | ------------------------------------- | ------- | --------------- |
| `ModelParamUsageDeprecation`                   | Replace -m/--model with -s/--select   |   Full  |       No        |
| `CustomOutputPathInSourceFreshnessDeprecation` | Remove -o/--output usage in `dbt source freshness` commands              |   Full  | Yes |


## Installation

### From PyPi

#### With uv (recommended)

We recommend using `uv`/`uvx` to run the package.
If you don't have `uv` installed, you can install `uv` and `uvx`, [following the instructions on the offical website](https://docs.astral.sh/uv/getting-started/installation/).

- to run the latest version of the tool: `uvx dbt-autofix`
- to run a specific version of the tool: `uvx dbt-autofix@0.1.2`
- to install the tool as a dedicated CLI: `uv tool install dbt-autofix`

#### With pip

You can also use `pip` if you prefer, but we then recommend installing the tool in its own Python virtual environment. Once in a venv, install the tool with `pip install dbt-autofix` and then run `dbt-autofix ...` 

### From the source repo

To run it from the git repo directly, install `uv` [following those instructions](https://docs.astral.sh/uv/getting-started/installation/) and then:

run the tool directly
```sh
uvx --from git+https://github.com/dbt-labs/dbt-autofix.git dbt-autofix --help
```

or install it so that it can be run with `dbt-cleanup` in the future
```sh
uv tool install --from git+https://github.com/dbt-labs/dbt-autofix.git dbt-autofix
```

## Usage

### `deprecations` - the main one

- `dbt-autofix deprecations`: refactor YAML and SQL files to fix some deprecations
  - add `--path <mypath>` to configure the path of the dbt project (defaults to `.`)
  - add `--dry-run` for running in dry run mode
  - add `--json` to get resulting data in a JSONL format
  - add `--json-schema-version v2.0.0-beta.4` to get the JSON schema from a specific Fusion release (by default we pick the latest)
  - add `--select <path>` to only select files in a given path (by default the tool will look at all files of the dbt project)
  - add `--include-packages` to also autofix the packages installed. Just note that those fixes will be reverted at the next `dbt deps` and the long term fix will be to update the packages to versions compatible with Fusion.
  - add `--behavior-changes` to run the _subset_ of fixes that would resolve deprecations that require a behavior change. Refer to the coverage tables above to determine which deprecations require behavior changes.

Each JSON object will have the following keys:

- "mode": "applied" or "dry_run" 
- "file_path": the full path of the file modified. Each file will appear only once
- "refactors": the list of refactoring rules applied

Calling `deprecations` without `--dry-run` should be safe if your dbt code is part of a git repo. 

Please review the suggested changes to your dbt project before merging to `main` and make those changes go through your typical CI/CD process.


### `jobs`

`dbt-autofix jobs`: update dbt platform jobs steps to use `-s`/`--select` selectors instead of `-m`/`--models`/`--model` which are deprecated in the Fusion engine

Run `dbt-autofix jobs --help` to see the required parameters and supported arguments.

This tool requires connecting to the dbt Admin API to retrieve and update jobs which means that the user token or service token used need to have Read and Write access to jobs

Running with `--dry-run`/`d` will output what changes would have been triggered without triggering them

Running with `--behavior-changes` will run the _subset_ of fixes that would resolve deprecations that require a behavior change. Refer to the coverage tables above to determine which deprecations require behavior changes.