# Generated by Plain 0.52.2 on 2025-07-08 01:19

import uuid

import plain.flags.models
import plain.models.deletion
from plain import models
from plain.models import migrations


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Flag",
            fields=[
                ("id", models.PrimaryKeyField()),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "name",
                    models.CharField(
                        max_length=255,
                        validators=[plain.flags.models.validate_flag_name],
                    ),
                ),
                ("description", models.TextField(required=False)),
                ("enabled", models.BooleanField(default=True)),
                ("used_at", models.DateTimeField(allow_null=True, required=False)),
            ],
        ),
        migrations.CreateModel(
            name="FlagResult",
            fields=[
                ("id", models.PrimaryKeyField()),
                ("uuid", models.UUIDField(default=uuid.uuid4)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("key", models.CharField(max_length=255)),
                ("value", models.JSONField()),
            ],
        ),
        migrations.AddConstraint(
            model_name="flag",
            constraint=models.UniqueConstraint(
                fields=("name",), name="plainflags_flag_unique_name"
            ),
        ),
        migrations.AddConstraint(
            model_name="flag",
            constraint=models.UniqueConstraint(
                fields=("uuid",), name="plainflags_flag_unique_uuid"
            ),
        ),
        migrations.AddField(
            model_name="flagresult",
            name="flag",
            field=models.ForeignKey(
                on_delete=plain.models.deletion.CASCADE, to="plainflags.flag"
            ),
        ),
        migrations.AddConstraint(
            model_name="flagresult",
            constraint=models.UniqueConstraint(
                fields=("flag", "key"), name="plainflags_flagresult_unique_key"
            ),
        ),
        migrations.AddConstraint(
            model_name="flagresult",
            constraint=models.UniqueConstraint(
                fields=("uuid",), name="plainflags_flagresult_unique_uuid"
            ),
        ),
    ]
