# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2
from t2iapi import basic_requests_pb2 as t2iapi_dot_basic__requests__pb2
from t2iapi import basic_responses_pb2 as t2iapi_dot_basic__responses__pb2
from t2iapi.device import device_requests_pb2 as t2iapi_dot_device_dot_device__requests__pb2
from t2iapi.device import device_responses_pb2 as t2iapi_dot_device_dot_device__responses__pb2


class DeviceServiceStub(object):
    """
    Service to handle device manipulations.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.SetDeviceOperatingMode = channel.unary_unary(
                '/t2iapi.device.DeviceService/SetDeviceOperatingMode',
                request_serializer=t2iapi_dot_device_dot_device__requests__pb2.SetDeviceOperatingModeRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.SetMdsOperatingMode = channel.unary_unary(
                '/t2iapi.device.DeviceService/SetMdsOperatingMode',
                request_serializer=t2iapi_dot_device_dot_device__requests__pb2.SetMdsOperatingModeRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.SendHello = channel.unary_unary(
                '/t2iapi.device.DeviceService/SendHello',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.SetClockDevice = channel.unary_unary(
                '/t2iapi.device.DeviceService/SetClockDevice',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.SetLanguage = channel.unary_unary(
                '/t2iapi.device.DeviceService/SetLanguage',
                request_serializer=t2iapi_dot_device_dot_device__requests__pb2.SetLanguageRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.SetMdsUiLanguage = channel.unary_unary(
                '/t2iapi.device.DeviceService/SetMdsUiLanguage',
                request_serializer=t2iapi_dot_device_dot_device__requests__pb2.SetMdsUiLanguageRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.GetMdsUiSupportedLanguages = channel.unary_unary(
                '/t2iapi.device.DeviceService/GetMdsUiSupportedLanguages',
                request_serializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_device_dot_device__responses__pb2.GetMdsUiSupportedLanguagesResponse.FromString,
                )
        self.GetRemovableDescriptorsOfClass = channel.unary_unary(
                '/t2iapi.device.DeviceService/GetRemovableDescriptorsOfClass',
                request_serializer=t2iapi_dot_device_dot_device__requests__pb2.GetRemovableDescriptorsOfClassRequest.SerializeToString,
                response_deserializer=t2iapi_dot_device_dot_device__responses__pb2.GetRemovableDescriptorsResponse.FromString,
                )
        self.RemoveDescriptor = channel.unary_unary(
                '/t2iapi.device.DeviceService/RemoveDescriptor',
                request_serializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.InsertDescriptor = channel.unary_unary(
                '/t2iapi.device.DeviceService/InsertDescriptor',
                request_serializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.TriggerDescriptorUpdate = channel.unary_unary(
                '/t2iapi.device.DeviceService/TriggerDescriptorUpdate',
                request_serializer=t2iapi_dot_device_dot_device__requests__pb2.TriggerDescriptorUpdateRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.TriggerAnyDescriptorUpdate = channel.unary_unary(
                '/t2iapi.device.DeviceService/TriggerAnyDescriptorUpdate',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.TriggerReport = channel.unary_unary(
                '/t2iapi.device.DeviceService/TriggerReport',
                request_serializer=t2iapi_dot_device_dot_device__requests__pb2.TriggerReportRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.SetBatteryUsage = channel.unary_unary(
                '/t2iapi.device.DeviceService/SetBatteryUsage',
                request_serializer=t2iapi_dot_device_dot_device__requests__pb2.SetBatteryUsageRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.ProvideInformationAboutLastCalibration = channel.unary_unary(
                '/t2iapi.device.DeviceService/ProvideInformationAboutLastCalibration',
                request_serializer=t2iapi_dot_device_dot_device__requests__pb2.ProvideInformationAboutLastCalibrationRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.ProvideInformationAboutNextCalibration = channel.unary_unary(
                '/t2iapi.device.DeviceService/ProvideInformationAboutNextCalibration',
                request_serializer=t2iapi_dot_device_dot_device__requests__pb2.ProvideInformationAboutNextCalibrationRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.GetAvailableDeviceMetaData = channel.unary_unary(
                '/t2iapi.device.DeviceService/GetAvailableDeviceMetaData',
                request_serializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_device_dot_device__responses__pb2.AvailableDeviceMetaDataResponse.FromString,
                )
        self.GetComponentSwVersion = channel.unary_unary(
                '/t2iapi.device.DeviceService/GetComponentSwVersion',
                request_serializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_device_dot_device__responses__pb2.GetComponentSwVersionResponse.FromString,
                )
        self.GetComponentHwVersion = channel.unary_unary(
                '/t2iapi.device.DeviceService/GetComponentHwVersion',
                request_serializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_device_dot_device__responses__pb2.GetComponentHwVersionResponse.FromString,
                )
        self.RequestIndicationOfNextCalibrationTimeRequired = channel.unary_unary(
                '/t2iapi.device.DeviceService/RequestIndicationOfNextCalibrationTimeRequired',
                request_serializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.IndicateTimeOfNextCalibrationToUser = channel.unary_unary(
                '/t2iapi.device.DeviceService/IndicateTimeOfNextCalibrationToUser',
                request_serializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_device_dot_device__responses__pb2.IndicateTimeOfNextCalibrationToUserResponse.FromString,
                )
        self.InsertContainmentTreeEntryForSequenceId = channel.unary_unary(
                '/t2iapi.device.DeviceService/InsertContainmentTreeEntryForSequenceId',
                request_serializer=t2iapi_dot_device_dot_device__requests__pb2.InsertContainmentTreeEntryForSequenceIdRequest.SerializeToString,
                response_deserializer=t2iapi_dot_device_dot_device__responses__pb2.InsertContainmentTreeEntryForSequenceIdResponse.FromString,
                )
        self.InsertContainmentTreeEntryWithStaticHandle = channel.unary_unary(
                '/t2iapi.device.DeviceService/InsertContainmentTreeEntryWithStaticHandle',
                request_serializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.SetActivationStateToOnAndShutDownAndRestartDevice = channel.unary_unary(
                '/t2iapi.device.DeviceService/SetActivationStateToOnAndShutDownAndRestartDevice',
                request_serializer=t2iapi_dot_basic__requests__pb2.RepeatedHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.ProvideExtensionElements = channel.unary_unary(
                '/t2iapi.device.DeviceService/ProvideExtensionElements',
                request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )
        self.RemoveProductionSpecificationElement = channel.unary_unary(
                '/t2iapi.device.DeviceService/RemoveProductionSpecificationElement',
                request_serializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_device_dot_device__responses__pb2.ProductionSpecificationElementResponse.FromString,
                )
        self.ChangeProductionSpecificationElement = channel.unary_unary(
                '/t2iapi.device.DeviceService/ChangeProductionSpecificationElement',
                request_serializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_device_dot_device__responses__pb2.ProductionSpecificationElementResponse.FromString,
                )
        self.InsertProductionSpecificationElement = channel.unary_unary(
                '/t2iapi.device.DeviceService/InsertProductionSpecificationElement',
                request_serializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_device_dot_device__responses__pb2.ProductionSpecificationElementResponse.FromString,
                )
        self.SetSafetyClassificationToMedAMedBOrMedC = channel.unary_unary(
                '/t2iapi.device.DeviceService/SetSafetyClassificationToMedAMedBOrMedC',
                request_serializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
                response_deserializer=t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
                )


class DeviceServiceServicer(object):
    """
    Service to handle device manipulations.
    """

    def SetDeviceOperatingMode(self, request, context):
        """
        Switch the device into a specific operating mode.
        This manipulation shall result in a Mds having a specific MdsOperatingMode.
        The manipulated state shall be persistent until a next manipulation call. If the device is not able to maintain
        the static state, it shall return RESULT_NOT_SUPPORTED.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetMdsOperatingMode(self, request, context):
        """
        Switch the provided MDS into a specific @OperatingMode.
        This manipulation shall result in a MDS having a specific MdsOperatingMode.
        The manipulated state shall be persistent until a next manipulation call. If the device is not able to maintain
        the static state, it shall return RESULT_NOT_SUPPORTED.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SendHello(self, request, context):
        """
        Announce the presence of the device in the network via a WS-Discovery Hello message.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetClockDevice(self, request, context):
        """
        Adjust the clock of the device as if it were set manually by a user.
        The manipulated state shall be persistent until a next manipulation call. If the device is not able to maintain
        the static state, it shall return RESULT_NOT_SUPPORTED.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetLanguage(self, request, context):
        """
        Set the device's (displayed) language to the given language.
        The manipulated state shall be persistent until a next manipulation call. If the device is not able to maintain
        the static state, it shall return RESULT_NOT_SUPPORTED.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetMdsUiLanguage(self, request, context):
        """
        Set the language of the component with a UI represented by the MDS to the given language.
        The manipulated state shall be persistent until a next manipulation call. If the device is not able to maintain
        the static state, it shall return RESULT_NOT_SUPPORTED.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetMdsUiSupportedLanguages(self, request, context):
        """
        Get all supported languages of the component with a UI represented by the MDS with the provided handle.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetRemovableDescriptorsOfClass(self, request, context):
        """
        Get all descriptor handles which can be removed and reinserted into the MDIB of the device
        and whose descriptors are of the given class.
        Includes handles which have been removed already and can be reinserted.
        Handles must stay the same once reinserted into the MDIB.

        Calling GetRemovableDescriptorsOfClass with descriptor_class = DESCRIPTOR_CLASS_ABSTRACT
        returns the unfiltered handles while other values for descriptor_class
        return only handles whose descriptors are of the given class.

        The unfiltered handles shall be representative of the devices capabilities
        to remove descriptors (at least one of every possible kind).
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RemoveDescriptor(self, request, context):
        """
        Remove a descriptor from the device MDIB.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def InsertDescriptor(self, request, context):
        """
        Insert a descriptor into the device MDIB.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def TriggerDescriptorUpdate(self, request, context):
        """
        Trigger a DescriptionManipulationReport that fulfills the following:

        For each given handle there exists an "Upt"-ReportPart that contains an updated descriptor, whose @DescriptorHandle
        is equal to the given handle, and that is contained in the DescriptionModificationReport.

        ---

        Note that when no handle is given, every DescriptionModificationReport fulfills the request.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def TriggerAnyDescriptorUpdate(self, request, context):
        """
        Trigger a descriptor update.
        The descriptor to update has to be chosen by the device. It is expected that this manipulation succeeds
        as long as there are descriptors than can be updated.
        This manipulation shall result in a msg:DescriptionModificationReport message containing a report part with
        msg:ReportPart/@ModificationType = "Upt".
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def TriggerReport(self, request, context):
        """
        Trigger a report message of the provided type.
        This manipulation of the device shall result in an msg:AbstractReport message of the provided type.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetBatteryUsage(self, request, context):
        """
        Use or not use the device's battery as the electrical power source.
        The manipulated state shall be persistent until a next manipulation call or until power failure. If the device is
        not able to maintain the static state, it shall return RESULT_NOT_SUPPORTED.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ProvideInformationAboutLastCalibration(self, request, context):
        """
        Provide information about the pm:CalibrationInfo for the given pm:AbstractDeviceComponentDescriptor.
        If the device is not able to provide the information, it shall return RESULT_NOT_SUPPORTED.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ProvideInformationAboutNextCalibration(self, request, context):
        """
        Provide information about the pm:NextCalibration for the given pm:AbstractDeviceComponentDescriptor.
        If the device is not able to provide the information, it shall return RESULT_NOT_SUPPORTED.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetAvailableDeviceMetaData(self, request, context):
        """
        Get the available device metadata of the pm:MdsDescriptor for the given handle. For each item of the metadata
        that is not available for this MDS leave the corresponding element empty. In this context, "available" does not
        mean a copy of the data from the pm:MdsDescriptor/pm:MetaData. It means a provision of the data which, in the
        user's opinion, must be present for this device.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetComponentSwVersion(self, request, context):
        """
        Get the software version of the requested pm:AbstractDeviceComponentDescriptor handle if it is representing
        a component with a software version.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetComponentHwVersion(self, request, context):
        """
        Get the hardware version of the requested pm:AbstractDeviceComponentDescriptor handle if it is representing
        a component with a hardware version.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RequestIndicationOfNextCalibrationTimeRequired(self, request, context):
        """
        Request for the given pm:AbstractDeviceComponentDescriptor handle, if it can be required by a particular standard
        or RISK MANAGEMENT process to indicate the time of the next calibration to the USER.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def IndicateTimeOfNextCalibrationToUser(self, request, context):
        """
        Indicate the time of the next calibration to the USER for the given pm:AbstractDeviceComponentDescriptor handle.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def InsertContainmentTreeEntryForSequenceId(self, request, context):
        """
        Make available the BICEPS CONTAINMENT TREE ENTRY (as defined in IEEE Std 11073-10700-2022) that was previously
        represented by the provided handle in the MDIB with the provided @SequenceId. If the BICEPS CONTAINMENT TREE ENTRY
        is absent in the current MDIB, it shall be inserted and its handle in the current MDIB shall be returned.
        If the BICEPS CONTAINMENT TREE ENTRY is already present in the current MDIB, only its handle shall be returned,
        no further action is required.

        Hint: Devices which use static handles for descriptors do not have to look up the entity that was previously
        represented by the requested handle, since they stay the same between the changes of the @SequenceId. It is
        sufficient to ensure the descriptor is present and return the handle.

        Example 1: returning the same handle for the Metric
        - device presented an MDIB with the Metric handle "metric_1" in @SequenceID "123"
        - device changes @SequenceID to "789" and presents a new MDIB
        - metric with the handle "metric_1" is still present in the current MDIB and represents the *same* metric
        as in @SequenceID "123"
        - InsertContainmentTreeEntryForSequenceId with handle="metric_1" and sequence_id="123" is executed
        - the handle "metric_1" is returned as the descriptor with this handle it is still available in the current MDIB
        - no further action from the device is required

        Example 2: returning a new handle for the MDS:
        - device presented an MDIB with MDS handle "mds0" in @SequenceID "123"
        - device changes @SequenceID to "789" and presents a new MDIB
        - MDS which had the Handle "mds0" in @SequenceId "123" is still present in the current MDIB, but it's Handle
        changed to "mds10"
        - InsertContainmentTreeEntryForSequenceId with handle="mds0" and sequence_id="123" is executed
        - the handle "mds10" is returned as the descriptor handle for that MDS has changed
        - no further action from the device is required

        Example 3: inserting the Channel into the current MDIB and returning the (new) handle:
        - device presented the Channel with handle "channel123" in @SequenceID "123"
        - device changes @SequenceID to "789" and presents a new MDIB
        - Channel which had the Handle "channel123" in @SequenceId "123" is no longer present in the current MDIB
        - InsertContainmentTreeEntryForSequenceId with handle="channel123" and sequence_id="123" is executed
        - Channel is inserted into the device's current MDIB with the handle "channel789"
        - the handle "channel789" is returned
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def InsertContainmentTreeEntryWithStaticHandle(self, request, context):
        """
        This manipulation is only applicable for devices which use static handles for descriptors across all sequences of
        MDIB's. If the device under test does not support static handles for descriptors, it shall return the GRPC Status Code
        UNIMPLEMENTED. If the request contains a handle that is unknown for the device, it shall return GRPC Status Code
        INVALID_ARGUMENT.

        Make available the BICEPS CONTAINMENT TREE ENTRY (as defined in IEEE Std 11073-10700-2022) that is represented by the
        provided handle in the device's MDIB. If the BICEPS CONTAINMENT TREE ENTRY is absent in the current MDIB, it shall be
        inserted. If the BICEPS CONTAINMENT TREE ENTRY is already present in the current MDIB no further action is required.

        Example 1: inserting the MDS into the current MDIB:
        - devices is able to present a MDS with the handle mds1 which is currently not present in devices MDIB
        - InsertContainmentTreeEntryWithStaticHandle with handle mds1 is executed
        - MDS with the handle mds1 is inserted into the device's current MDIB
        - no further action from the device is required

        Example 2: Metric is already present in the current MDIB:
        - Metric with the handle "metric_1" is already present in the devices current MDIB
        - InsertContainmentTreeEntryWithStaticHandle with handle "metric_1" is executed
        - no further action from the device is required

        Example 3: the requested descriptor is not known for the device:
        - descriptor with the handle "some_channel" is not present in the devices current MDIB and no such descriptor can exist in the devices MDIB
        - InsertContainmentTreeEntryWithStaticHandle with handle "some_channel" is executed
        - GRPC Status Code INVALID_ARGUMENT is returned since the requested entity is unknown for the device
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetActivationStateToOnAndShutDownAndRestartDevice(self, request, context):
        """
        Shut down the device gracefully and then restart it. Before the shut down the @ActivationState of the
        pm:AbstractDeviceComponentStates with the provided handles must be set to 'ON' and not be changed until the
        shutdown process has been completed, except for changes due to the shutdown process itself.
        When restarting, the device should have a new pm:MdibVersionGroup/@SequenceId.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ProvideExtensionElements(self, request, context):
        """
        Provide all possible EXTENSION(s) with @ext:MustUnderstand = true
        (as defined in IEEE Std 11073‐10700‐2022 and in IEEE Std 11073-10207-2017).
        It is allowed to provide the EXTENSION(s) sequentially.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RemoveProductionSpecificationElement(self, request, context):
        """
        Request to remove a pm:ProductionSpecification element of the given descriptor represented by the provided handle.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ChangeProductionSpecificationElement(self, request, context):
        """
        Request to change a pm:ProductionSpecification element of the given descriptor represented by the provided handle.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def InsertProductionSpecificationElement(self, request, context):
        """
        Request to insert a pm:ProductionSpecification element into the given descriptor represented by the provided handle.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetSafetyClassificationToMedAMedBOrMedC(self, request, context):
        """
        Set the @SafetyClassification to a value ∈ { MedA, MedB, MedC } for the descriptor with the provided handle.
        'MedA', 'MedB' and 'MedC' are of type pm:SafetyClassification as defined in the IEEE Std 11073-10207-2017.
        The manipulated device state shall be persistent until a next manipulation call. If the device is not able to
        maintain the static state, it shall return RESULT_NOT_SUPPORTED.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_DeviceServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'SetDeviceOperatingMode': grpc.unary_unary_rpc_method_handler(
                    servicer.SetDeviceOperatingMode,
                    request_deserializer=t2iapi_dot_device_dot_device__requests__pb2.SetDeviceOperatingModeRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'SetMdsOperatingMode': grpc.unary_unary_rpc_method_handler(
                    servicer.SetMdsOperatingMode,
                    request_deserializer=t2iapi_dot_device_dot_device__requests__pb2.SetMdsOperatingModeRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'SendHello': grpc.unary_unary_rpc_method_handler(
                    servicer.SendHello,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'SetClockDevice': grpc.unary_unary_rpc_method_handler(
                    servicer.SetClockDevice,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'SetLanguage': grpc.unary_unary_rpc_method_handler(
                    servicer.SetLanguage,
                    request_deserializer=t2iapi_dot_device_dot_device__requests__pb2.SetLanguageRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'SetMdsUiLanguage': grpc.unary_unary_rpc_method_handler(
                    servicer.SetMdsUiLanguage,
                    request_deserializer=t2iapi_dot_device_dot_device__requests__pb2.SetMdsUiLanguageRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'GetMdsUiSupportedLanguages': grpc.unary_unary_rpc_method_handler(
                    servicer.GetMdsUiSupportedLanguages,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.FromString,
                    response_serializer=t2iapi_dot_device_dot_device__responses__pb2.GetMdsUiSupportedLanguagesResponse.SerializeToString,
            ),
            'GetRemovableDescriptorsOfClass': grpc.unary_unary_rpc_method_handler(
                    servicer.GetRemovableDescriptorsOfClass,
                    request_deserializer=t2iapi_dot_device_dot_device__requests__pb2.GetRemovableDescriptorsOfClassRequest.FromString,
                    response_serializer=t2iapi_dot_device_dot_device__responses__pb2.GetRemovableDescriptorsResponse.SerializeToString,
            ),
            'RemoveDescriptor': grpc.unary_unary_rpc_method_handler(
                    servicer.RemoveDescriptor,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'InsertDescriptor': grpc.unary_unary_rpc_method_handler(
                    servicer.InsertDescriptor,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'TriggerDescriptorUpdate': grpc.unary_unary_rpc_method_handler(
                    servicer.TriggerDescriptorUpdate,
                    request_deserializer=t2iapi_dot_device_dot_device__requests__pb2.TriggerDescriptorUpdateRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'TriggerAnyDescriptorUpdate': grpc.unary_unary_rpc_method_handler(
                    servicer.TriggerAnyDescriptorUpdate,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'TriggerReport': grpc.unary_unary_rpc_method_handler(
                    servicer.TriggerReport,
                    request_deserializer=t2iapi_dot_device_dot_device__requests__pb2.TriggerReportRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'SetBatteryUsage': grpc.unary_unary_rpc_method_handler(
                    servicer.SetBatteryUsage,
                    request_deserializer=t2iapi_dot_device_dot_device__requests__pb2.SetBatteryUsageRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'ProvideInformationAboutLastCalibration': grpc.unary_unary_rpc_method_handler(
                    servicer.ProvideInformationAboutLastCalibration,
                    request_deserializer=t2iapi_dot_device_dot_device__requests__pb2.ProvideInformationAboutLastCalibrationRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'ProvideInformationAboutNextCalibration': grpc.unary_unary_rpc_method_handler(
                    servicer.ProvideInformationAboutNextCalibration,
                    request_deserializer=t2iapi_dot_device_dot_device__requests__pb2.ProvideInformationAboutNextCalibrationRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'GetAvailableDeviceMetaData': grpc.unary_unary_rpc_method_handler(
                    servicer.GetAvailableDeviceMetaData,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.FromString,
                    response_serializer=t2iapi_dot_device_dot_device__responses__pb2.AvailableDeviceMetaDataResponse.SerializeToString,
            ),
            'GetComponentSwVersion': grpc.unary_unary_rpc_method_handler(
                    servicer.GetComponentSwVersion,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.FromString,
                    response_serializer=t2iapi_dot_device_dot_device__responses__pb2.GetComponentSwVersionResponse.SerializeToString,
            ),
            'GetComponentHwVersion': grpc.unary_unary_rpc_method_handler(
                    servicer.GetComponentHwVersion,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.FromString,
                    response_serializer=t2iapi_dot_device_dot_device__responses__pb2.GetComponentHwVersionResponse.SerializeToString,
            ),
            'RequestIndicationOfNextCalibrationTimeRequired': grpc.unary_unary_rpc_method_handler(
                    servicer.RequestIndicationOfNextCalibrationTimeRequired,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'IndicateTimeOfNextCalibrationToUser': grpc.unary_unary_rpc_method_handler(
                    servicer.IndicateTimeOfNextCalibrationToUser,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.FromString,
                    response_serializer=t2iapi_dot_device_dot_device__responses__pb2.IndicateTimeOfNextCalibrationToUserResponse.SerializeToString,
            ),
            'InsertContainmentTreeEntryForSequenceId': grpc.unary_unary_rpc_method_handler(
                    servicer.InsertContainmentTreeEntryForSequenceId,
                    request_deserializer=t2iapi_dot_device_dot_device__requests__pb2.InsertContainmentTreeEntryForSequenceIdRequest.FromString,
                    response_serializer=t2iapi_dot_device_dot_device__responses__pb2.InsertContainmentTreeEntryForSequenceIdResponse.SerializeToString,
            ),
            'InsertContainmentTreeEntryWithStaticHandle': grpc.unary_unary_rpc_method_handler(
                    servicer.InsertContainmentTreeEntryWithStaticHandle,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'SetActivationStateToOnAndShutDownAndRestartDevice': grpc.unary_unary_rpc_method_handler(
                    servicer.SetActivationStateToOnAndShutDownAndRestartDevice,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.RepeatedHandleRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'ProvideExtensionElements': grpc.unary_unary_rpc_method_handler(
                    servicer.ProvideExtensionElements,
                    request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
            'RemoveProductionSpecificationElement': grpc.unary_unary_rpc_method_handler(
                    servicer.RemoveProductionSpecificationElement,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.FromString,
                    response_serializer=t2iapi_dot_device_dot_device__responses__pb2.ProductionSpecificationElementResponse.SerializeToString,
            ),
            'ChangeProductionSpecificationElement': grpc.unary_unary_rpc_method_handler(
                    servicer.ChangeProductionSpecificationElement,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.FromString,
                    response_serializer=t2iapi_dot_device_dot_device__responses__pb2.ProductionSpecificationElementResponse.SerializeToString,
            ),
            'InsertProductionSpecificationElement': grpc.unary_unary_rpc_method_handler(
                    servicer.InsertProductionSpecificationElement,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.FromString,
                    response_serializer=t2iapi_dot_device_dot_device__responses__pb2.ProductionSpecificationElementResponse.SerializeToString,
            ),
            'SetSafetyClassificationToMedAMedBOrMedC': grpc.unary_unary_rpc_method_handler(
                    servicer.SetSafetyClassificationToMedAMedBOrMedC,
                    request_deserializer=t2iapi_dot_basic__requests__pb2.BasicHandleRequest.FromString,
                    response_serializer=t2iapi_dot_basic__responses__pb2.BasicResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            't2iapi.device.DeviceService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class DeviceService(object):
    """
    Service to handle device manipulations.
    """

    @staticmethod
    def SetDeviceOperatingMode(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/SetDeviceOperatingMode',
            t2iapi_dot_device_dot_device__requests__pb2.SetDeviceOperatingModeRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SetMdsOperatingMode(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/SetMdsOperatingMode',
            t2iapi_dot_device_dot_device__requests__pb2.SetMdsOperatingModeRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SendHello(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/SendHello',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SetClockDevice(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/SetClockDevice',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SetLanguage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/SetLanguage',
            t2iapi_dot_device_dot_device__requests__pb2.SetLanguageRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SetMdsUiLanguage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/SetMdsUiLanguage',
            t2iapi_dot_device_dot_device__requests__pb2.SetMdsUiLanguageRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetMdsUiSupportedLanguages(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/GetMdsUiSupportedLanguages',
            t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
            t2iapi_dot_device_dot_device__responses__pb2.GetMdsUiSupportedLanguagesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetRemovableDescriptorsOfClass(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/GetRemovableDescriptorsOfClass',
            t2iapi_dot_device_dot_device__requests__pb2.GetRemovableDescriptorsOfClassRequest.SerializeToString,
            t2iapi_dot_device_dot_device__responses__pb2.GetRemovableDescriptorsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RemoveDescriptor(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/RemoveDescriptor',
            t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def InsertDescriptor(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/InsertDescriptor',
            t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def TriggerDescriptorUpdate(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/TriggerDescriptorUpdate',
            t2iapi_dot_device_dot_device__requests__pb2.TriggerDescriptorUpdateRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def TriggerAnyDescriptorUpdate(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/TriggerAnyDescriptorUpdate',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def TriggerReport(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/TriggerReport',
            t2iapi_dot_device_dot_device__requests__pb2.TriggerReportRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SetBatteryUsage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/SetBatteryUsage',
            t2iapi_dot_device_dot_device__requests__pb2.SetBatteryUsageRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ProvideInformationAboutLastCalibration(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/ProvideInformationAboutLastCalibration',
            t2iapi_dot_device_dot_device__requests__pb2.ProvideInformationAboutLastCalibrationRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ProvideInformationAboutNextCalibration(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/ProvideInformationAboutNextCalibration',
            t2iapi_dot_device_dot_device__requests__pb2.ProvideInformationAboutNextCalibrationRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetAvailableDeviceMetaData(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/GetAvailableDeviceMetaData',
            t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
            t2iapi_dot_device_dot_device__responses__pb2.AvailableDeviceMetaDataResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetComponentSwVersion(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/GetComponentSwVersion',
            t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
            t2iapi_dot_device_dot_device__responses__pb2.GetComponentSwVersionResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetComponentHwVersion(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/GetComponentHwVersion',
            t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
            t2iapi_dot_device_dot_device__responses__pb2.GetComponentHwVersionResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RequestIndicationOfNextCalibrationTimeRequired(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/RequestIndicationOfNextCalibrationTimeRequired',
            t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def IndicateTimeOfNextCalibrationToUser(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/IndicateTimeOfNextCalibrationToUser',
            t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
            t2iapi_dot_device_dot_device__responses__pb2.IndicateTimeOfNextCalibrationToUserResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def InsertContainmentTreeEntryForSequenceId(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/InsertContainmentTreeEntryForSequenceId',
            t2iapi_dot_device_dot_device__requests__pb2.InsertContainmentTreeEntryForSequenceIdRequest.SerializeToString,
            t2iapi_dot_device_dot_device__responses__pb2.InsertContainmentTreeEntryForSequenceIdResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def InsertContainmentTreeEntryWithStaticHandle(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/InsertContainmentTreeEntryWithStaticHandle',
            t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SetActivationStateToOnAndShutDownAndRestartDevice(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/SetActivationStateToOnAndShutDownAndRestartDevice',
            t2iapi_dot_basic__requests__pb2.RepeatedHandleRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ProvideExtensionElements(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/ProvideExtensionElements',
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RemoveProductionSpecificationElement(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/RemoveProductionSpecificationElement',
            t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
            t2iapi_dot_device_dot_device__responses__pb2.ProductionSpecificationElementResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ChangeProductionSpecificationElement(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/ChangeProductionSpecificationElement',
            t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
            t2iapi_dot_device_dot_device__responses__pb2.ProductionSpecificationElementResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def InsertProductionSpecificationElement(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/InsertProductionSpecificationElement',
            t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
            t2iapi_dot_device_dot_device__responses__pb2.ProductionSpecificationElementResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SetSafetyClassificationToMedAMedBOrMedC(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/t2iapi.device.DeviceService/SetSafetyClassificationToMedAMedBOrMedC',
            t2iapi_dot_basic__requests__pb2.BasicHandleRequest.SerializeToString,
            t2iapi_dot_basic__responses__pb2.BasicResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
