# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.deployment import Deployment
from ..types.get_application_deployment_response import GetApplicationDeploymentResponse
from .raw_client import AsyncRawApplicationVersionsClient, RawApplicationVersionsClient


class ApplicationVersionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawApplicationVersionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawApplicationVersionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawApplicationVersionsClient
        """
        return self._raw_client

    def list(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        version: typing.Optional[str] = None,
        deployment_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Deployment]:
        """
        Fetch all deployments for a given application ID with optional filters such as deployment ID or version. Supports pagination.

        Parameters
        ----------
        id : str
            Id of the application

        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        version : typing.Optional[str]
            Deployment version. Filter deployments by version.

        deployment_id : typing.Optional[str]
            Deployment ID. Filter deployments by a specific ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Deployment]
            List of deployments matching the provided filters.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.application_versions.list(
            id="id",
            limit=10,
            offset=0,
            version="1",
            deployment_id="deployment123",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            id,
            limit=limit,
            offset=offset,
            version=version,
            deployment_id=deployment_id,
            request_options=request_options,
        )

    def get(
        self, id: str, deployment_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetApplicationDeploymentResponse:
        """
        Get Deployment associated with the provided application ID and deployment ID.

        Parameters
        ----------
        id : str
            Application id of the application

        deployment_id : str
            Deployment id of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetApplicationDeploymentResponse
            Deployment details returned successfully.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.application_versions.get(
            id="id",
            deployment_id="deploymentId",
        )
        """
        _response = self._raw_client.get(id, deployment_id, request_options=request_options)
        return _response.data


class AsyncApplicationVersionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawApplicationVersionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawApplicationVersionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawApplicationVersionsClient
        """
        return self._raw_client

    async def list(
        self,
        id: str,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        version: typing.Optional[str] = None,
        deployment_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Deployment]:
        """
        Fetch all deployments for a given application ID with optional filters such as deployment ID or version. Supports pagination.

        Parameters
        ----------
        id : str
            Id of the application

        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        version : typing.Optional[str]
            Deployment version. Filter deployments by version.

        deployment_id : typing.Optional[str]
            Deployment ID. Filter deployments by a specific ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Deployment]
            List of deployments matching the provided filters.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.application_versions.list(
                id="id",
                limit=10,
                offset=0,
                version="1",
                deployment_id="deployment123",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            id,
            limit=limit,
            offset=offset,
            version=version,
            deployment_id=deployment_id,
            request_options=request_options,
        )

    async def get(
        self, id: str, deployment_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetApplicationDeploymentResponse:
        """
        Get Deployment associated with the provided application ID and deployment ID.

        Parameters
        ----------
        id : str
            Application id of the application

        deployment_id : str
            Deployment id of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetApplicationDeploymentResponse
            Deployment details returned successfully.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.application_versions.get(
                id="id",
                deployment_id="deploymentId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, deployment_id, request_options=request_options)
        return _response.data
