# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.data_directory import DataDirectory
from ..types.data_directory_manifest import DataDirectoryManifest
from ..types.empty_response import EmptyResponse
from ..types.file_info import FileInfo
from ..types.get_data_directory_response import GetDataDirectoryResponse
from ..types.get_signed_ur_ls_response import GetSignedUrLsResponse
from ..types.multi_part_upload_response import MultiPartUploadResponse
from ..types.operation import Operation
from .raw_client import AsyncRawDataDirectoriesClient, RawDataDirectoriesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DataDirectoriesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDataDirectoriesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDataDirectoriesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDataDirectoriesClient
        """
        return self._raw_client

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetDataDirectoryResponse:
        """
        Get a data directory by its ID.

        Args:
            id (str): The ID of the data directory to retrieve
            user_info: Current authenticated user info

        Returns:
            DataDirectoryResponse: Response containing the retrieved data directory

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetDataDirectoryResponse
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_directories.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(
        self,
        id: str,
        *,
        delete_contents: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EmptyResponse:
        """
        Delete a data directory and optionally its contents.

        Args:
            id: Unique identifier of the data directory to delete
            delete_contents: If True, also deletes the data directory's contents
            user_info: Authenticated user information

        Returns:
            EmptyResponse: Empty response indicating successful deletion

        Parameters
        ----------
        id : str

        delete_contents : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmptyResponse
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_directories.delete(
            id="id",
            delete_contents=True,
        )
        """
        _response = self._raw_client.delete(id, delete_contents=delete_contents, request_options=request_options)
        return _response.data

    def list(
        self,
        *,
        fqn: typing.Optional[str] = None,
        ml_repo_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[DataDirectory]:
        """
        List all data directories with optional filtering and pagination.

        Args:
            filters: Query parameters for filtering and pagination
                - ml_repo_id: Filter data directories by ml repo ID
                - name: Optional filter data directories by name
                - limit: Optional maximum number of data directories to return
                - offset: Optional number of data directories to skip
            user_info: Authenticated user information

        Returns:
            ListDataDirectoriesResponse: List of data directories and pagination info

        Parameters
        ----------
        fqn : typing.Optional[str]

        ml_repo_id : typing.Optional[str]

        name : typing.Optional[str]

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[DataDirectory]
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.data_directories.list(
            fqn="fqn",
            ml_repo_id="ml_repo_id",
            name="name",
            limit=1,
            offset=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            fqn=fqn, ml_repo_id=ml_repo_id, name=name, limit=limit, offset=offset, request_options=request_options
        )

    def create_or_update(
        self, *, manifest: DataDirectoryManifest, request_options: typing.Optional[RequestOptions] = None
    ) -> GetDataDirectoryResponse:
        """
        Parameters
        ----------
        manifest : DataDirectoryManifest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetDataDirectoryResponse
            Successful Response

        Examples
        --------
        from truefoundry_sdk import (
            DataDirectoryManifest,
            TrueFoundry,
            TrueFoundryManagedSource,
        )

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_directories.create_or_update(
            manifest=DataDirectoryManifest(
                name="name",
                ml_repo="ml_repo",
                metadata={"key": "value"},
                source=TrueFoundryManagedSource(),
            ),
        )
        """
        _response = self._raw_client.create_or_update(manifest=manifest, request_options=request_options)
        return _response.data

    def list_files(
        self,
        *,
        id: str,
        path: typing.Optional[str] = OMIT,
        limit: typing.Optional[int] = OMIT,
        page_token: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[FileInfo]:
        """
        List files in a dataset.

        Args:
            request_dto: Request containing dataset ID, path, page token and limit
            user_info: Authenticated user information

        Returns:
            ListFilesResponse: Response containing files and pagination info

        Parameters
        ----------
        id : str

        path : typing.Optional[str]

        limit : typing.Optional[int]

        page_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[FileInfo]
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.data_directories.list_files(
            id="id",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list_files(
            id=id, path=path, limit=limit, page_token=page_token, request_options=request_options
        )

    def delete_files(
        self, *, id: str, paths: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> EmptyResponse:
        """
        Delete files from the dataset.

        Args:
            request_dto: Request containing dataset ID and paths
            user_info: Authenticated user information

        Returns:
            EmptyResponse: Empty response indicating successful deletion

        Parameters
        ----------
        id : str

        paths : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmptyResponse
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_directories.delete_files(
            id="id",
            paths=["paths"],
        )
        """
        _response = self._raw_client.delete_files(id=id, paths=paths, request_options=request_options)
        return _response.data

    def get_signed_urls(
        self,
        *,
        id: str,
        paths: typing.Sequence[str],
        operation: Operation,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetSignedUrLsResponse:
        """
        Get signed URLs for a dataset.

        Args:
            request_dto: Request containing dataset ID, paths and operation
            user_info: Authenticated user information

        Returns:
            GetSignedURLsResponse: Response containing signed URLs

        Parameters
        ----------
        id : str

        paths : typing.Sequence[str]

        operation : Operation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSignedUrLsResponse
            Successful Response

        Examples
        --------
        from truefoundry_sdk import Operation, TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_directories.get_signed_urls(
            id="id",
            paths=["paths"],
            operation=Operation.READ,
        )
        """
        _response = self._raw_client.get_signed_urls(
            id=id, paths=paths, operation=operation, request_options=request_options
        )
        return _response.data

    def create_multipart_upload(
        self, *, id: str, path: str, num_parts: int, request_options: typing.Optional[RequestOptions] = None
    ) -> MultiPartUploadResponse:
        """
        Create a multipart upload for a dataset

        Args:
            request_dto: Request containing dataset ID, path and number of parts
            user_info: Authenticated user information

        Returns:
            MultiPartUploadResponse: Response containing multipart upload info

        Parameters
        ----------
        id : str

        path : str

        num_parts : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MultiPartUploadResponse
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.data_directories.create_multipart_upload(
            id="id",
            path="path",
            num_parts=1,
        )
        """
        _response = self._raw_client.create_multipart_upload(
            id=id, path=path, num_parts=num_parts, request_options=request_options
        )
        return _response.data


class AsyncDataDirectoriesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDataDirectoriesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDataDirectoriesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDataDirectoriesClient
        """
        return self._raw_client

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetDataDirectoryResponse:
        """
        Get a data directory by its ID.

        Args:
            id (str): The ID of the data directory to retrieve
            user_info: Current authenticated user info

        Returns:
            DataDirectoryResponse: Response containing the retrieved data directory

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetDataDirectoryResponse
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.data_directories.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(
        self,
        id: str,
        *,
        delete_contents: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EmptyResponse:
        """
        Delete a data directory and optionally its contents.

        Args:
            id: Unique identifier of the data directory to delete
            delete_contents: If True, also deletes the data directory's contents
            user_info: Authenticated user information

        Returns:
            EmptyResponse: Empty response indicating successful deletion

        Parameters
        ----------
        id : str

        delete_contents : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmptyResponse
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.data_directories.delete(
                id="id",
                delete_contents=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, delete_contents=delete_contents, request_options=request_options)
        return _response.data

    async def list(
        self,
        *,
        fqn: typing.Optional[str] = None,
        ml_repo_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[DataDirectory]:
        """
        List all data directories with optional filtering and pagination.

        Args:
            filters: Query parameters for filtering and pagination
                - ml_repo_id: Filter data directories by ml repo ID
                - name: Optional filter data directories by name
                - limit: Optional maximum number of data directories to return
                - offset: Optional number of data directories to skip
            user_info: Authenticated user information

        Returns:
            ListDataDirectoriesResponse: List of data directories and pagination info

        Parameters
        ----------
        fqn : typing.Optional[str]

        ml_repo_id : typing.Optional[str]

        name : typing.Optional[str]

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[DataDirectory]
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.data_directories.list(
                fqn="fqn",
                ml_repo_id="ml_repo_id",
                name="name",
                limit=1,
                offset=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            fqn=fqn, ml_repo_id=ml_repo_id, name=name, limit=limit, offset=offset, request_options=request_options
        )

    async def create_or_update(
        self, *, manifest: DataDirectoryManifest, request_options: typing.Optional[RequestOptions] = None
    ) -> GetDataDirectoryResponse:
        """
        Parameters
        ----------
        manifest : DataDirectoryManifest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetDataDirectoryResponse
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import (
            AsyncTrueFoundry,
            DataDirectoryManifest,
            TrueFoundryManagedSource,
        )

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.data_directories.create_or_update(
                manifest=DataDirectoryManifest(
                    name="name",
                    ml_repo="ml_repo",
                    metadata={"key": "value"},
                    source=TrueFoundryManagedSource(),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update(manifest=manifest, request_options=request_options)
        return _response.data

    async def list_files(
        self,
        *,
        id: str,
        path: typing.Optional[str] = OMIT,
        limit: typing.Optional[int] = OMIT,
        page_token: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[FileInfo]:
        """
        List files in a dataset.

        Args:
            request_dto: Request containing dataset ID, path, page token and limit
            user_info: Authenticated user information

        Returns:
            ListFilesResponse: Response containing files and pagination info

        Parameters
        ----------
        id : str

        path : typing.Optional[str]

        limit : typing.Optional[int]

        page_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[FileInfo]
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.data_directories.list_files(
                id="id",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list_files(
            id=id, path=path, limit=limit, page_token=page_token, request_options=request_options
        )

    async def delete_files(
        self, *, id: str, paths: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> EmptyResponse:
        """
        Delete files from the dataset.

        Args:
            request_dto: Request containing dataset ID and paths
            user_info: Authenticated user information

        Returns:
            EmptyResponse: Empty response indicating successful deletion

        Parameters
        ----------
        id : str

        paths : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmptyResponse
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.data_directories.delete_files(
                id="id",
                paths=["paths"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_files(id=id, paths=paths, request_options=request_options)
        return _response.data

    async def get_signed_urls(
        self,
        *,
        id: str,
        paths: typing.Sequence[str],
        operation: Operation,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetSignedUrLsResponse:
        """
        Get signed URLs for a dataset.

        Args:
            request_dto: Request containing dataset ID, paths and operation
            user_info: Authenticated user information

        Returns:
            GetSignedURLsResponse: Response containing signed URLs

        Parameters
        ----------
        id : str

        paths : typing.Sequence[str]

        operation : Operation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSignedUrLsResponse
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry, Operation

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.data_directories.get_signed_urls(
                id="id",
                paths=["paths"],
                operation=Operation.READ,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_signed_urls(
            id=id, paths=paths, operation=operation, request_options=request_options
        )
        return _response.data

    async def create_multipart_upload(
        self, *, id: str, path: str, num_parts: int, request_options: typing.Optional[RequestOptions] = None
    ) -> MultiPartUploadResponse:
        """
        Create a multipart upload for a dataset

        Args:
            request_dto: Request containing dataset ID, path and number of parts
            user_info: Authenticated user information

        Returns:
            MultiPartUploadResponse: Response containing multipart upload info

        Parameters
        ----------
        id : str

        path : str

        num_parts : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MultiPartUploadResponse
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.data_directories.create_multipart_upload(
                id="id",
                path="path",
                num_parts=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_multipart_upload(
            id=id, path=path, num_parts=num_parts, request_options=request_options
        )
        return _response.data
