# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.environment import Environment
from ..types.environment_manifest import EnvironmentManifest
from ..types.get_environment_response import GetEnvironmentResponse
from .raw_client import AsyncRawEnvironmentsClient, RawEnvironmentsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EnvironmentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEnvironmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEnvironmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEnvironmentsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Environment]:
        """
        List environments, if no environments are found, default environments are created and returned. Pagination is available based on query parameters

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Environment]
            Returns a list of environment. If pagination parameters are provided, the response includes paginated data

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.environments.list(
            limit=10,
            offset=0,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(limit=limit, offset=offset, request_options=request_options)

    def create_or_update(
        self,
        *,
        manifest: EnvironmentManifest,
        dry_run: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetEnvironmentResponse:
        """
        Creates a new Environment or updates an existing Environment.

        Parameters
        ----------
        manifest : EnvironmentManifest
            Environment Manifest

        dry_run : typing.Optional[bool]
            Dry run

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEnvironmentResponse
            Returns the created or updated Environment

        Examples
        --------
        from truefoundry_sdk import (
            EnvironmentColor,
            EnvironmentManifest,
            EnvironmentOptimizeFor,
            TrueFoundry,
        )

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.environments.create_or_update(
            manifest=EnvironmentManifest(
                name="name",
                color=EnvironmentColor(),
                is_production=True,
                optimize_for=EnvironmentOptimizeFor.COST,
            ),
        )
        """
        _response = self._raw_client.create_or_update(
            manifest=manifest, dry_run=dry_run, request_options=request_options
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetEnvironmentResponse:
        """
        Get Environment associated with the provided id.

        Parameters
        ----------
        id : str
            Environment id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEnvironmentResponse
            Returns the Environment associated with the provided id

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.environments.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> bool:
        """
        Delete Environment associated with the provided id.

        Parameters
        ----------
        id : str
            Environment id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        bool
            Returns true if the Environment is deleted successfully

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.environments.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data


class AsyncEnvironmentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEnvironmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEnvironmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEnvironmentsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Environment]:
        """
        List environments, if no environments are found, default environments are created and returned. Pagination is available based on query parameters

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Environment]
            Returns a list of environment. If pagination parameters are provided, the response includes paginated data

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.environments.list(
                limit=10,
                offset=0,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(limit=limit, offset=offset, request_options=request_options)

    async def create_or_update(
        self,
        *,
        manifest: EnvironmentManifest,
        dry_run: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetEnvironmentResponse:
        """
        Creates a new Environment or updates an existing Environment.

        Parameters
        ----------
        manifest : EnvironmentManifest
            Environment Manifest

        dry_run : typing.Optional[bool]
            Dry run

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEnvironmentResponse
            Returns the created or updated Environment

        Examples
        --------
        import asyncio

        from truefoundry_sdk import (
            AsyncTrueFoundry,
            EnvironmentColor,
            EnvironmentManifest,
            EnvironmentOptimizeFor,
        )

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.environments.create_or_update(
                manifest=EnvironmentManifest(
                    name="name",
                    color=EnvironmentColor(),
                    is_production=True,
                    optimize_for=EnvironmentOptimizeFor.COST,
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update(
            manifest=manifest, dry_run=dry_run, request_options=request_options
        )
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetEnvironmentResponse:
        """
        Get Environment associated with the provided id.

        Parameters
        ----------
        id : str
            Environment id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEnvironmentResponse
            Returns the Environment associated with the provided id

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.environments.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> bool:
        """
        Delete Environment associated with the provided id.

        Parameters
        ----------
        id : str
            Environment id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        bool
            Returns true if the Environment is deleted successfully

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.environments.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data
