# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.gateway_configuration import GatewayConfiguration
from .raw_client import AsyncRawAiGatewayClient, RawAiGatewayClient
from .types.ai_gateway_get_gateway_config_request_type import AiGatewayGetGatewayConfigRequestType


class AiGatewayClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAiGatewayClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAiGatewayClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAiGatewayClient
        """
        return self._raw_client

    def get_gateway_config(
        self, type: AiGatewayGetGatewayConfigRequestType, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GatewayConfiguration:
        """
        Get Gateway configuration based on type for the tenant.

        Parameters
        ----------
        type : AiGatewayGetGatewayConfigRequestType
            Type of Config

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GatewayConfiguration
            Gateway configuration retrieved successfully

        Examples
        --------
        from truefoundry_sdk import TrueFoundry
        from truefoundry_sdk.internal.ai_gateway import (
            AiGatewayGetGatewayConfigRequestType,
        )

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.ai_gateway.get_gateway_config(
            type=AiGatewayGetGatewayConfigRequestType.GATEWAY_RATE_LIMITING_CONFIG,
        )
        """
        _response = self._raw_client.get_gateway_config(type, request_options=request_options)
        return _response.data


class AsyncAiGatewayClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAiGatewayClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAiGatewayClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAiGatewayClient
        """
        return self._raw_client

    async def get_gateway_config(
        self, type: AiGatewayGetGatewayConfigRequestType, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GatewayConfiguration:
        """
        Get Gateway configuration based on type for the tenant.

        Parameters
        ----------
        type : AiGatewayGetGatewayConfigRequestType
            Type of Config

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GatewayConfiguration
            Gateway configuration retrieved successfully

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry
        from truefoundry_sdk.internal.ai_gateway import (
            AiGatewayGetGatewayConfigRequestType,
        )

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.ai_gateway.get_gateway_config(
                type=AiGatewayGetGatewayConfigRequestType.GATEWAY_RATE_LIMITING_CONFIG,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_gateway_config(type, request_options=request_options)
        return _response.data
