# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...types.gateway_configuration import GatewayConfiguration
from .types.ai_gateway_get_gateway_config_request_type import AiGatewayGetGatewayConfigRequestType


class RawAiGatewayClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_gateway_config(
        self, type: AiGatewayGetGatewayConfigRequestType, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GatewayConfiguration]:
        """
        Get Gateway configuration based on type for the tenant.

        Parameters
        ----------
        type : AiGatewayGetGatewayConfigRequestType
            Type of Config

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GatewayConfiguration]
            Gateway configuration retrieved successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/svc/v1/llm-gateway/config/{jsonable_encoder(type)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GatewayConfiguration,
                    parse_obj_as(
                        type_=GatewayConfiguration,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawAiGatewayClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_gateway_config(
        self, type: AiGatewayGetGatewayConfigRequestType, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GatewayConfiguration]:
        """
        Get Gateway configuration based on type for the tenant.

        Parameters
        ----------
        type : AiGatewayGetGatewayConfigRequestType
            Type of Config

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GatewayConfiguration]
            Gateway configuration retrieved successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/svc/v1/llm-gateway/config/{jsonable_encoder(type)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GatewayConfiguration,
                    parse_obj_as(
                        type_=GatewayConfiguration,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
