# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawApplicationsClient, RawApplicationsClient


class ApplicationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawApplicationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawApplicationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawApplicationsClient
        """
        return self._raw_client

    def promote_rollout(
        self, id: str, *, full: typing.Optional[bool] = False, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Promote an application rollout for canary and blue-green.

        Parameters
        ----------
        id : str
            Id of the application

        full : typing.Optional[bool]
            Whether to promote a rollout to full

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.applications.promote_rollout(
            id="id",
            full=True,
        )
        """
        _response = self._raw_client.promote_rollout(id, full=full, request_options=request_options)
        return _response.data

    def get_pod_template_hash_to_deployment_version(
        self,
        id: str,
        *,
        pod_template_hashes: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, float]:
        """
        This endpoint fetches the pod template hash to deployment version map for a specific application.

        Parameters
        ----------
        id : str
            Id of the application

        pod_template_hashes : typing.Optional[str]
            Pod Template Hashes (comma separated for multiple)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, float]
            Successfully retrieved the pod template hash to deployment version map.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.applications.get_pod_template_hash_to_deployment_version(
            id="id",
            pod_template_hashes="podTemplateHashes",
        )
        """
        _response = self._raw_client.get_pod_template_hash_to_deployment_version(
            id, pod_template_hashes=pod_template_hashes, request_options=request_options
        )
        return _response.data


class AsyncApplicationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawApplicationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawApplicationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawApplicationsClient
        """
        return self._raw_client

    async def promote_rollout(
        self, id: str, *, full: typing.Optional[bool] = False, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Promote an application rollout for canary and blue-green.

        Parameters
        ----------
        id : str
            Id of the application

        full : typing.Optional[bool]
            Whether to promote a rollout to full

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.applications.promote_rollout(
                id="id",
                full=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.promote_rollout(id, full=full, request_options=request_options)
        return _response.data

    async def get_pod_template_hash_to_deployment_version(
        self,
        id: str,
        *,
        pod_template_hashes: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, float]:
        """
        This endpoint fetches the pod template hash to deployment version map for a specific application.

        Parameters
        ----------
        id : str
            Id of the application

        pod_template_hashes : typing.Optional[str]
            Pod Template Hashes (comma separated for multiple)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, float]
            Successfully retrieved the pod template hash to deployment version map.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.applications.get_pod_template_hash_to_deployment_version(
                id="id",
                pod_template_hashes="podTemplateHashes",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_pod_template_hash_to_deployment_version(
            id, pod_template_hashes=pod_template_hashes, request_options=request_options
        )
        return _response.data
