# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawInternalClient, RawInternalClient

if typing.TYPE_CHECKING:
    from .ai_gateway.client import AiGatewayClient, AsyncAiGatewayClient
    from .applications.client import ApplicationsClient, AsyncApplicationsClient
    from .artifact_versions.client import ArtifactVersionsClient, AsyncArtifactVersionsClient
    from .clusters.client import AsyncClustersClient, ClustersClient
    from .deployments.client import AsyncDeploymentsClient, DeploymentsClient
    from .docker_registries.client import AsyncDockerRegistriesClient, DockerRegistriesClient
    from .metrics.client import AsyncMetricsClient, MetricsClient
    from .ml.client import AsyncMlClient, MlClient
    from .users.client import AsyncUsersClient, UsersClient
    from .vcs.client import AsyncVcsClient, VcsClient
    from .workflows.client import AsyncWorkflowsClient, WorkflowsClient


class InternalClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawInternalClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._users: typing.Optional[UsersClient] = None
        self._ai_gateway: typing.Optional[AiGatewayClient] = None
        self._clusters: typing.Optional[ClustersClient] = None
        self._deployments: typing.Optional[DeploymentsClient] = None
        self._applications: typing.Optional[ApplicationsClient] = None
        self._metrics: typing.Optional[MetricsClient] = None
        self._vcs: typing.Optional[VcsClient] = None
        self._docker_registries: typing.Optional[DockerRegistriesClient] = None
        self._workflows: typing.Optional[WorkflowsClient] = None
        self._artifact_versions: typing.Optional[ArtifactVersionsClient] = None
        self._ml: typing.Optional[MlClient] = None

    @property
    def with_raw_response(self) -> RawInternalClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawInternalClient
        """
        return self._raw_client

    def get_id_from_fqn(
        self, type: str, *, fqn: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Get IDs associated with the FQN for various entity types, such as deployment, application, workspace, or cluster.

        Parameters
        ----------
        type : str
            Entity Type

        fqn : str
            Entity FQN

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            Returns the IDs for the specified entity type based on the provided FQN. For example, deploymentId, applicationId, and workspaceId for type deployment, or applicationId and workspaceId for type app.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.get_id_from_fqn(
            type="type",
            fqn="fqn",
        )
        """
        _response = self._raw_client.get_id_from_fqn(type, fqn=fqn, request_options=request_options)
        return _response.data

    @property
    def users(self):
        if self._users is None:
            from .users.client import UsersClient  # noqa: E402

            self._users = UsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def ai_gateway(self):
        if self._ai_gateway is None:
            from .ai_gateway.client import AiGatewayClient  # noqa: E402

            self._ai_gateway = AiGatewayClient(client_wrapper=self._client_wrapper)
        return self._ai_gateway

    @property
    def clusters(self):
        if self._clusters is None:
            from .clusters.client import ClustersClient  # noqa: E402

            self._clusters = ClustersClient(client_wrapper=self._client_wrapper)
        return self._clusters

    @property
    def deployments(self):
        if self._deployments is None:
            from .deployments.client import DeploymentsClient  # noqa: E402

            self._deployments = DeploymentsClient(client_wrapper=self._client_wrapper)
        return self._deployments

    @property
    def applications(self):
        if self._applications is None:
            from .applications.client import ApplicationsClient  # noqa: E402

            self._applications = ApplicationsClient(client_wrapper=self._client_wrapper)
        return self._applications

    @property
    def metrics(self):
        if self._metrics is None:
            from .metrics.client import MetricsClient  # noqa: E402

            self._metrics = MetricsClient(client_wrapper=self._client_wrapper)
        return self._metrics

    @property
    def vcs(self):
        if self._vcs is None:
            from .vcs.client import VcsClient  # noqa: E402

            self._vcs = VcsClient(client_wrapper=self._client_wrapper)
        return self._vcs

    @property
    def docker_registries(self):
        if self._docker_registries is None:
            from .docker_registries.client import DockerRegistriesClient  # noqa: E402

            self._docker_registries = DockerRegistriesClient(client_wrapper=self._client_wrapper)
        return self._docker_registries

    @property
    def workflows(self):
        if self._workflows is None:
            from .workflows.client import WorkflowsClient  # noqa: E402

            self._workflows = WorkflowsClient(client_wrapper=self._client_wrapper)
        return self._workflows

    @property
    def artifact_versions(self):
        if self._artifact_versions is None:
            from .artifact_versions.client import ArtifactVersionsClient  # noqa: E402

            self._artifact_versions = ArtifactVersionsClient(client_wrapper=self._client_wrapper)
        return self._artifact_versions

    @property
    def ml(self):
        if self._ml is None:
            from .ml.client import MlClient  # noqa: E402

            self._ml = MlClient(client_wrapper=self._client_wrapper)
        return self._ml


class AsyncInternalClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawInternalClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._users: typing.Optional[AsyncUsersClient] = None
        self._ai_gateway: typing.Optional[AsyncAiGatewayClient] = None
        self._clusters: typing.Optional[AsyncClustersClient] = None
        self._deployments: typing.Optional[AsyncDeploymentsClient] = None
        self._applications: typing.Optional[AsyncApplicationsClient] = None
        self._metrics: typing.Optional[AsyncMetricsClient] = None
        self._vcs: typing.Optional[AsyncVcsClient] = None
        self._docker_registries: typing.Optional[AsyncDockerRegistriesClient] = None
        self._workflows: typing.Optional[AsyncWorkflowsClient] = None
        self._artifact_versions: typing.Optional[AsyncArtifactVersionsClient] = None
        self._ml: typing.Optional[AsyncMlClient] = None

    @property
    def with_raw_response(self) -> AsyncRawInternalClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawInternalClient
        """
        return self._raw_client

    async def get_id_from_fqn(
        self, type: str, *, fqn: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Get IDs associated with the FQN for various entity types, such as deployment, application, workspace, or cluster.

        Parameters
        ----------
        type : str
            Entity Type

        fqn : str
            Entity FQN

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            Returns the IDs for the specified entity type based on the provided FQN. For example, deploymentId, applicationId, and workspaceId for type deployment, or applicationId and workspaceId for type app.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.get_id_from_fqn(
                type="type",
                fqn="fqn",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_id_from_fqn(type, fqn=fqn, request_options=request_options)
        return _response.data

    @property
    def users(self):
        if self._users is None:
            from .users.client import AsyncUsersClient  # noqa: E402

            self._users = AsyncUsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def ai_gateway(self):
        if self._ai_gateway is None:
            from .ai_gateway.client import AsyncAiGatewayClient  # noqa: E402

            self._ai_gateway = AsyncAiGatewayClient(client_wrapper=self._client_wrapper)
        return self._ai_gateway

    @property
    def clusters(self):
        if self._clusters is None:
            from .clusters.client import AsyncClustersClient  # noqa: E402

            self._clusters = AsyncClustersClient(client_wrapper=self._client_wrapper)
        return self._clusters

    @property
    def deployments(self):
        if self._deployments is None:
            from .deployments.client import AsyncDeploymentsClient  # noqa: E402

            self._deployments = AsyncDeploymentsClient(client_wrapper=self._client_wrapper)
        return self._deployments

    @property
    def applications(self):
        if self._applications is None:
            from .applications.client import AsyncApplicationsClient  # noqa: E402

            self._applications = AsyncApplicationsClient(client_wrapper=self._client_wrapper)
        return self._applications

    @property
    def metrics(self):
        if self._metrics is None:
            from .metrics.client import AsyncMetricsClient  # noqa: E402

            self._metrics = AsyncMetricsClient(client_wrapper=self._client_wrapper)
        return self._metrics

    @property
    def vcs(self):
        if self._vcs is None:
            from .vcs.client import AsyncVcsClient  # noqa: E402

            self._vcs = AsyncVcsClient(client_wrapper=self._client_wrapper)
        return self._vcs

    @property
    def docker_registries(self):
        if self._docker_registries is None:
            from .docker_registries.client import AsyncDockerRegistriesClient  # noqa: E402

            self._docker_registries = AsyncDockerRegistriesClient(client_wrapper=self._client_wrapper)
        return self._docker_registries

    @property
    def workflows(self):
        if self._workflows is None:
            from .workflows.client import AsyncWorkflowsClient  # noqa: E402

            self._workflows = AsyncWorkflowsClient(client_wrapper=self._client_wrapper)
        return self._workflows

    @property
    def artifact_versions(self):
        if self._artifact_versions is None:
            from .artifact_versions.client import AsyncArtifactVersionsClient  # noqa: E402

            self._artifact_versions = AsyncArtifactVersionsClient(client_wrapper=self._client_wrapper)
        return self._artifact_versions

    @property
    def ml(self):
        if self._ml is None:
            from .ml.client import AsyncMlClient  # noqa: E402

            self._ml = AsyncMlClient(client_wrapper=self._client_wrapper)
        return self._ml
