# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.get_auto_provisioning_state_response import GetAutoProvisioningStateResponse
from .raw_client import AsyncRawClustersClient, RawClustersClient


class ClustersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawClustersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawClustersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawClustersClient
        """
        return self._raw_client

    def get_autoprovisioning_state(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetAutoProvisioningStateResponse:
        """
        Get the auto provisioning status for the provided cluster

        Parameters
        ----------
        id : str
            Cluster id of the cluster

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAutoProvisioningStateResponse
            Returns the auto provisioning status for the cluster

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.clusters.get_autoprovisioning_state(
            id="id",
        )
        """
        _response = self._raw_client.get_autoprovisioning_state(id, request_options=request_options)
        return _response.data


class AsyncClustersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawClustersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawClustersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawClustersClient
        """
        return self._raw_client

    async def get_autoprovisioning_state(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetAutoProvisioningStateResponse:
        """
        Get the auto provisioning status for the provided cluster

        Parameters
        ----------
        id : str
            Cluster id of the cluster

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAutoProvisioningStateResponse
            Returns the auto provisioning status for the cluster

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.clusters.get_autoprovisioning_state(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_autoprovisioning_state(id, request_options=request_options)
        return _response.data
