# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.application_type import ApplicationType
from ...types.deployment_build import DeploymentBuild
from ...types.deployment_status import DeploymentStatus
from ...types.get_suggested_deployment_endpoint_response import GetSuggestedDeploymentEndpointResponse
from ...types.presigned_url_object import PresignedUrlObject
from .raw_client import AsyncRawDeploymentsClient, RawDeploymentsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DeploymentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDeploymentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDeploymentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDeploymentsClient
        """
        return self._raw_client

    def get_deployment_statuses(
        self, id: str, deployment_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[DeploymentStatus]:
        """
        This endpoint returns all statuses for a specific deployment in a given application.

        Parameters
        ----------
        id : str
            Application id of the application

        deployment_id : str
            Deployment id of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[DeploymentStatus]
            Deployment statuses returned successfully.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.deployments.get_deployment_statuses(
            id="id",
            deployment_id="deploymentId",
        )
        """
        _response = self._raw_client.get_deployment_statuses(id, deployment_id, request_options=request_options)
        return _response.data

    def get_builds(
        self, id: str, deployment_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[DeploymentBuild]:
        """
        This endpoint returns all build details associated with a specific deployment in a given application.

        Parameters
        ----------
        id : str
            Application id of the application

        deployment_id : str
            Deployment id of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[DeploymentBuild]
            Deployment builds returned successfully.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.deployments.get_builds(
            id="id",
            deployment_id="deploymentId",
        )
        """
        _response = self._raw_client.get_builds(id, deployment_id, request_options=request_options)
        return _response.data

    def get_code_upload_url(
        self, *, service_name: str, workspace_fqn: str, request_options: typing.Optional[RequestOptions] = None
    ) -> PresignedUrlObject:
        """
        Generate presigned URL to upload code for given serviceName and workspaceFqn

        Parameters
        ----------
        service_name : str
            ServiceName of the deployment

        workspace_fqn : str
            WorkSpaceFQN of the workspace

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PresignedUrlObject
            Returns a presigned URL and URI as json object

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.deployments.get_code_upload_url(
            service_name="serviceName",
            workspace_fqn="workspaceFqn",
        )
        """
        _response = self._raw_client.get_code_upload_url(
            service_name=service_name, workspace_fqn=workspace_fqn, request_options=request_options
        )
        return _response.data

    def get_suggested_endpoint(
        self,
        *,
        application_type: ApplicationType,
        application_name: str,
        workspace_id: str,
        base_domain: typing.Optional[str] = None,
        port: typing.Optional[str] = None,
        prefer_wildcard: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetSuggestedDeploymentEndpointResponse:
        """
        Generate deployment endpoint based on the provided query parameters.

        Parameters
        ----------
        application_type : ApplicationType
            Application Type

        application_name : str
            Application name

        workspace_id : str
            Workspace id

        base_domain : typing.Optional[str]
            Base domain

        port : typing.Optional[str]
            Port

        prefer_wildcard : typing.Optional[bool]
            Prefer wildcard

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSuggestedDeploymentEndpointResponse
            Returns host and path as json object

        Examples
        --------
        from truefoundry_sdk import ApplicationType, TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.deployments.get_suggested_endpoint(
            application_type=ApplicationType.ASYNC_SERVICE,
            application_name="applicationName",
            workspace_id="workspaceId",
            base_domain="baseDomain",
            port="port",
            prefer_wildcard=True,
        )
        """
        _response = self._raw_client.get_suggested_endpoint(
            application_type=application_type,
            application_name=application_name,
            workspace_id=workspace_id,
            base_domain=base_domain,
            port=port,
            prefer_wildcard=prefer_wildcard,
            request_options=request_options,
        )
        return _response.data


class AsyncDeploymentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDeploymentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDeploymentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDeploymentsClient
        """
        return self._raw_client

    async def get_deployment_statuses(
        self, id: str, deployment_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[DeploymentStatus]:
        """
        This endpoint returns all statuses for a specific deployment in a given application.

        Parameters
        ----------
        id : str
            Application id of the application

        deployment_id : str
            Deployment id of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[DeploymentStatus]
            Deployment statuses returned successfully.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.deployments.get_deployment_statuses(
                id="id",
                deployment_id="deploymentId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_deployment_statuses(id, deployment_id, request_options=request_options)
        return _response.data

    async def get_builds(
        self, id: str, deployment_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[DeploymentBuild]:
        """
        This endpoint returns all build details associated with a specific deployment in a given application.

        Parameters
        ----------
        id : str
            Application id of the application

        deployment_id : str
            Deployment id of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[DeploymentBuild]
            Deployment builds returned successfully.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.deployments.get_builds(
                id="id",
                deployment_id="deploymentId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_builds(id, deployment_id, request_options=request_options)
        return _response.data

    async def get_code_upload_url(
        self, *, service_name: str, workspace_fqn: str, request_options: typing.Optional[RequestOptions] = None
    ) -> PresignedUrlObject:
        """
        Generate presigned URL to upload code for given serviceName and workspaceFqn

        Parameters
        ----------
        service_name : str
            ServiceName of the deployment

        workspace_fqn : str
            WorkSpaceFQN of the workspace

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PresignedUrlObject
            Returns a presigned URL and URI as json object

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.deployments.get_code_upload_url(
                service_name="serviceName",
                workspace_fqn="workspaceFqn",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_code_upload_url(
            service_name=service_name, workspace_fqn=workspace_fqn, request_options=request_options
        )
        return _response.data

    async def get_suggested_endpoint(
        self,
        *,
        application_type: ApplicationType,
        application_name: str,
        workspace_id: str,
        base_domain: typing.Optional[str] = None,
        port: typing.Optional[str] = None,
        prefer_wildcard: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetSuggestedDeploymentEndpointResponse:
        """
        Generate deployment endpoint based on the provided query parameters.

        Parameters
        ----------
        application_type : ApplicationType
            Application Type

        application_name : str
            Application name

        workspace_id : str
            Workspace id

        base_domain : typing.Optional[str]
            Base domain

        port : typing.Optional[str]
            Port

        prefer_wildcard : typing.Optional[bool]
            Prefer wildcard

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSuggestedDeploymentEndpointResponse
            Returns host and path as json object

        Examples
        --------
        import asyncio

        from truefoundry_sdk import ApplicationType, AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.deployments.get_suggested_endpoint(
                application_type=ApplicationType.ASYNC_SERVICE,
                application_name="applicationName",
                workspace_id="workspaceId",
                base_domain="baseDomain",
                port="port",
                prefer_wildcard=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_suggested_endpoint(
            application_type=application_type,
            application_name=application_name,
            workspace_id=workspace_id,
            base_domain=base_domain,
            port=port,
            prefer_wildcard=prefer_wildcard,
            request_options=request_options,
        )
        return _response.data
