# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.bad_request_error import BadRequestError
from ...errors.not_found_error import NotFoundError
from ...types.application_type import ApplicationType
from ...types.deployment_build import DeploymentBuild
from ...types.deployment_status import DeploymentStatus
from ...types.get_suggested_deployment_endpoint_response import GetSuggestedDeploymentEndpointResponse
from ...types.presigned_url_object import PresignedUrlObject

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawDeploymentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_deployment_statuses(
        self, id: str, deployment_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[DeploymentStatus]]:
        """
        This endpoint returns all statuses for a specific deployment in a given application.

        Parameters
        ----------
        id : str
            Application id of the application

        deployment_id : str
            Deployment id of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[DeploymentStatus]]
            Deployment statuses returned successfully.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}/deployments/{jsonable_encoder(deployment_id)}/statuses",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[DeploymentStatus],
                    parse_obj_as(
                        type_=typing.List[DeploymentStatus],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_builds(
        self, id: str, deployment_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[DeploymentBuild]]:
        """
        This endpoint returns all build details associated with a specific deployment in a given application.

        Parameters
        ----------
        id : str
            Application id of the application

        deployment_id : str
            Deployment id of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[DeploymentBuild]]
            Deployment builds returned successfully.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}/deployments/{jsonable_encoder(deployment_id)}/builds",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[DeploymentBuild],
                    parse_obj_as(
                        type_=typing.List[DeploymentBuild],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_code_upload_url(
        self, *, service_name: str, workspace_fqn: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PresignedUrlObject]:
        """
        Generate presigned URL to upload code for given serviceName and workspaceFqn

        Parameters
        ----------
        service_name : str
            ServiceName of the deployment

        workspace_fqn : str
            WorkSpaceFQN of the workspace

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PresignedUrlObject]
            Returns a presigned URL and URI as json object
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/svc/v1/deployment/code-upload-url",
            method="POST",
            json={
                "serviceName": service_name,
                "workspaceFqn": workspace_fqn,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PresignedUrlObject,
                    parse_obj_as(
                        type_=PresignedUrlObject,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_suggested_endpoint(
        self,
        *,
        application_type: ApplicationType,
        application_name: str,
        workspace_id: str,
        base_domain: typing.Optional[str] = None,
        port: typing.Optional[str] = None,
        prefer_wildcard: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetSuggestedDeploymentEndpointResponse]:
        """
        Generate deployment endpoint based on the provided query parameters.

        Parameters
        ----------
        application_type : ApplicationType
            Application Type

        application_name : str
            Application name

        workspace_id : str
            Workspace id

        base_domain : typing.Optional[str]
            Base domain

        port : typing.Optional[str]
            Port

        prefer_wildcard : typing.Optional[bool]
            Prefer wildcard

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetSuggestedDeploymentEndpointResponse]
            Returns host and path as json object
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/svc/v1/deployment/deployment-endpoint",
            method="GET",
            params={
                "applicationType": application_type,
                "applicationName": application_name,
                "workspaceId": workspace_id,
                "baseDomain": base_domain,
                "port": port,
                "preferWildcard": prefer_wildcard,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetSuggestedDeploymentEndpointResponse,
                    parse_obj_as(
                        type_=GetSuggestedDeploymentEndpointResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawDeploymentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_deployment_statuses(
        self, id: str, deployment_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[DeploymentStatus]]:
        """
        This endpoint returns all statuses for a specific deployment in a given application.

        Parameters
        ----------
        id : str
            Application id of the application

        deployment_id : str
            Deployment id of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[DeploymentStatus]]
            Deployment statuses returned successfully.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}/deployments/{jsonable_encoder(deployment_id)}/statuses",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[DeploymentStatus],
                    parse_obj_as(
                        type_=typing.List[DeploymentStatus],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_builds(
        self, id: str, deployment_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[DeploymentBuild]]:
        """
        This endpoint returns all build details associated with a specific deployment in a given application.

        Parameters
        ----------
        id : str
            Application id of the application

        deployment_id : str
            Deployment id of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[DeploymentBuild]]
            Deployment builds returned successfully.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/svc/v1/apps/{jsonable_encoder(id)}/deployments/{jsonable_encoder(deployment_id)}/builds",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[DeploymentBuild],
                    parse_obj_as(
                        type_=typing.List[DeploymentBuild],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_code_upload_url(
        self, *, service_name: str, workspace_fqn: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PresignedUrlObject]:
        """
        Generate presigned URL to upload code for given serviceName and workspaceFqn

        Parameters
        ----------
        service_name : str
            ServiceName of the deployment

        workspace_fqn : str
            WorkSpaceFQN of the workspace

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PresignedUrlObject]
            Returns a presigned URL and URI as json object
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/svc/v1/deployment/code-upload-url",
            method="POST",
            json={
                "serviceName": service_name,
                "workspaceFqn": workspace_fqn,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PresignedUrlObject,
                    parse_obj_as(
                        type_=PresignedUrlObject,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_suggested_endpoint(
        self,
        *,
        application_type: ApplicationType,
        application_name: str,
        workspace_id: str,
        base_domain: typing.Optional[str] = None,
        port: typing.Optional[str] = None,
        prefer_wildcard: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetSuggestedDeploymentEndpointResponse]:
        """
        Generate deployment endpoint based on the provided query parameters.

        Parameters
        ----------
        application_type : ApplicationType
            Application Type

        application_name : str
            Application name

        workspace_id : str
            Workspace id

        base_domain : typing.Optional[str]
            Base domain

        port : typing.Optional[str]
            Port

        prefer_wildcard : typing.Optional[bool]
            Prefer wildcard

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetSuggestedDeploymentEndpointResponse]
            Returns host and path as json object
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/svc/v1/deployment/deployment-endpoint",
            method="GET",
            params={
                "applicationType": application_type,
                "applicationName": application_name,
                "workspaceId": workspace_id,
                "baseDomain": base_domain,
                "port": port,
                "preferWildcard": prefer_wildcard,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetSuggestedDeploymentEndpointResponse,
                    parse_obj_as(
                        type_=GetSuggestedDeploymentEndpointResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
