# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawDockerRegistriesClient, RawDockerRegistriesClient
from .types.docker_registries_create_repository_response import DockerRegistriesCreateRepositoryResponse
from .types.docker_registries_get_credentials_response import DockerRegistriesGetCredentialsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DockerRegistriesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDockerRegistriesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDockerRegistriesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDockerRegistriesClient
        """
        return self._raw_client

    def create_repository(
        self,
        *,
        fqn: str,
        application_name: str,
        workspace_fqn: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DockerRegistriesCreateRepositoryResponse:
        """
        Create a docker repository in the provided workspace.

        Parameters
        ----------
        fqn : str
            Docker registry FQN

        application_name : str
            Application Name for the image being built

        workspace_fqn : str
            FQN for the workspace of application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DockerRegistriesCreateRepositoryResponse
            Returns the Repository name.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.docker_registries.create_repository(
            fqn="fqn",
            application_name="applicationName",
            workspace_fqn="workspaceFqn",
        )
        """
        _response = self._raw_client.create_repository(
            fqn=fqn, application_name=application_name, workspace_fqn=workspace_fqn, request_options=request_options
        )
        return _response.data

    def get_credentials(
        self,
        *,
        fqn: typing.Optional[str] = None,
        cluster_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DockerRegistriesGetCredentialsResponse:
        """
        Get docker registry credentials for building and pushing an image.

        Parameters
        ----------
        fqn : typing.Optional[str]
            Docker registry FQN

        cluster_id : typing.Optional[str]
            Cluster Id if provided will fetch the default docker registry for the cluster

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DockerRegistriesGetCredentialsResponse
            Returns the docker registry credentials.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.docker_registries.get_credentials(
            fqn="fqn",
            cluster_id="clusterId",
        )
        """
        _response = self._raw_client.get_credentials(fqn=fqn, cluster_id=cluster_id, request_options=request_options)
        return _response.data


class AsyncDockerRegistriesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDockerRegistriesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDockerRegistriesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDockerRegistriesClient
        """
        return self._raw_client

    async def create_repository(
        self,
        *,
        fqn: str,
        application_name: str,
        workspace_fqn: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DockerRegistriesCreateRepositoryResponse:
        """
        Create a docker repository in the provided workspace.

        Parameters
        ----------
        fqn : str
            Docker registry FQN

        application_name : str
            Application Name for the image being built

        workspace_fqn : str
            FQN for the workspace of application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DockerRegistriesCreateRepositoryResponse
            Returns the Repository name.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.docker_registries.create_repository(
                fqn="fqn",
                application_name="applicationName",
                workspace_fqn="workspaceFqn",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_repository(
            fqn=fqn, application_name=application_name, workspace_fqn=workspace_fqn, request_options=request_options
        )
        return _response.data

    async def get_credentials(
        self,
        *,
        fqn: typing.Optional[str] = None,
        cluster_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DockerRegistriesGetCredentialsResponse:
        """
        Get docker registry credentials for building and pushing an image.

        Parameters
        ----------
        fqn : typing.Optional[str]
            Docker registry FQN

        cluster_id : typing.Optional[str]
            Cluster Id if provided will fetch the default docker registry for the cluster

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DockerRegistriesGetCredentialsResponse
            Returns the docker registry credentials.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.docker_registries.get_credentials(
                fqn="fqn",
                cluster_id="clusterId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_credentials(
            fqn=fqn, cluster_id=cluster_id, request_options=request_options
        )
        return _response.data
