# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.not_found_error import NotFoundError
from .types.docker_registries_create_repository_response import DockerRegistriesCreateRepositoryResponse
from .types.docker_registries_get_credentials_response import DockerRegistriesGetCredentialsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawDockerRegistriesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create_repository(
        self,
        *,
        fqn: str,
        application_name: str,
        workspace_fqn: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DockerRegistriesCreateRepositoryResponse]:
        """
        Create a docker repository in the provided workspace.

        Parameters
        ----------
        fqn : str
            Docker registry FQN

        application_name : str
            Application Name for the image being built

        workspace_fqn : str
            FQN for the workspace of application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DockerRegistriesCreateRepositoryResponse]
            Returns the Repository name.
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/svc/v1/docker-registry/create-repo",
            method="POST",
            json={
                "fqn": fqn,
                "applicationName": application_name,
                "workspaceFqn": workspace_fqn,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DockerRegistriesCreateRepositoryResponse,
                    parse_obj_as(
                        type_=DockerRegistriesCreateRepositoryResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_credentials(
        self,
        *,
        fqn: typing.Optional[str] = None,
        cluster_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DockerRegistriesGetCredentialsResponse]:
        """
        Get docker registry credentials for building and pushing an image.

        Parameters
        ----------
        fqn : typing.Optional[str]
            Docker registry FQN

        cluster_id : typing.Optional[str]
            Cluster Id if provided will fetch the default docker registry for the cluster

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DockerRegistriesGetCredentialsResponse]
            Returns the docker registry credentials.
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/svc/v1/docker-registry/creds",
            method="GET",
            params={
                "fqn": fqn,
                "clusterId": cluster_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DockerRegistriesGetCredentialsResponse,
                    parse_obj_as(
                        type_=DockerRegistriesGetCredentialsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawDockerRegistriesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create_repository(
        self,
        *,
        fqn: str,
        application_name: str,
        workspace_fqn: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DockerRegistriesCreateRepositoryResponse]:
        """
        Create a docker repository in the provided workspace.

        Parameters
        ----------
        fqn : str
            Docker registry FQN

        application_name : str
            Application Name for the image being built

        workspace_fqn : str
            FQN for the workspace of application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DockerRegistriesCreateRepositoryResponse]
            Returns the Repository name.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/svc/v1/docker-registry/create-repo",
            method="POST",
            json={
                "fqn": fqn,
                "applicationName": application_name,
                "workspaceFqn": workspace_fqn,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DockerRegistriesCreateRepositoryResponse,
                    parse_obj_as(
                        type_=DockerRegistriesCreateRepositoryResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_credentials(
        self,
        *,
        fqn: typing.Optional[str] = None,
        cluster_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DockerRegistriesGetCredentialsResponse]:
        """
        Get docker registry credentials for building and pushing an image.

        Parameters
        ----------
        fqn : typing.Optional[str]
            Docker registry FQN

        cluster_id : typing.Optional[str]
            Cluster Id if provided will fetch the default docker registry for the cluster

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DockerRegistriesGetCredentialsResponse]
            Returns the docker registry credentials.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/svc/v1/docker-registry/creds",
            method="GET",
            params={
                "fqn": fqn,
                "clusterId": cluster_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DockerRegistriesGetCredentialsResponse,
                    parse_obj_as(
                        type_=DockerRegistriesGetCredentialsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
