# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.get_authenticated_vcsurl_response import GetAuthenticatedVcsurlResponse
from ...types.git_repository_exists_response import GitRepositoryExistsResponse
from .raw_client import AsyncRawVcsClient, RawVcsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class VcsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVcsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawVcsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVcsClient
        """
        return self._raw_client

    def get_repository_details(
        self, *, repo_url: str, id: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> GitRepositoryExistsResponse:
        """
        Parameters
        ----------
        repo_url : str
            The URL of the repository

        id : typing.Optional[str]
            The integration id of the repository

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GitRepositoryExistsResponse
            Returns git repository details if git repository exists and is accessible

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.vcs.get_repository_details(
            repo_url="repoURL",
        )
        """
        _response = self._raw_client.get_repository_details(repo_url=repo_url, id=id, request_options=request_options)
        return _response.data

    def get_authenticated_url(
        self, *, repo_url: str, request_options: typing.Optional[RequestOptions] = None
    ) -> GetAuthenticatedVcsurlResponse:
        """
        Parameters
        ----------
        repo_url : str
            Repository URL (e.g., https://github.com/user/repo, https://bitbucket.org/user/repo)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAuthenticatedVcsurlResponse
            Returns an authenticated VCS URL for the repository

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.vcs.get_authenticated_url(
            repo_url="repoURL",
        )
        """
        _response = self._raw_client.get_authenticated_url(repo_url=repo_url, request_options=request_options)
        return _response.data


class AsyncVcsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVcsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawVcsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVcsClient
        """
        return self._raw_client

    async def get_repository_details(
        self, *, repo_url: str, id: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> GitRepositoryExistsResponse:
        """
        Parameters
        ----------
        repo_url : str
            The URL of the repository

        id : typing.Optional[str]
            The integration id of the repository

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GitRepositoryExistsResponse
            Returns git repository details if git repository exists and is accessible

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.vcs.get_repository_details(
                repo_url="repoURL",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_repository_details(
            repo_url=repo_url, id=id, request_options=request_options
        )
        return _response.data

    async def get_authenticated_url(
        self, *, repo_url: str, request_options: typing.Optional[RequestOptions] = None
    ) -> GetAuthenticatedVcsurlResponse:
        """
        Parameters
        ----------
        repo_url : str
            Repository URL (e.g., https://github.com/user/repo, https://bitbucket.org/user/repo)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAuthenticatedVcsurlResponse
            Returns an authenticated VCS URL for the repository

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.vcs.get_authenticated_url(
                repo_url="repoURL",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_authenticated_url(repo_url=repo_url, request_options=request_options)
        return _response.data
