# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawWorkflowsClient, RawWorkflowsClient
from .types.workflows_execute_workflow_response import WorkflowsExecuteWorkflowResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WorkflowsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkflowsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWorkflowsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkflowsClient
        """
        return self._raw_client

    def execute_workflow(
        self,
        application_id: str,
        *,
        inputs: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        inputs_literal_map: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowsExecuteWorkflowResponse:
        """
        Execute a workflow for the specified application

        Parameters
        ----------
        application_id : str
            Id of the application

        inputs : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Workflow inputs

        inputs_literal_map : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Workflow inputs literal map

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowsExecuteWorkflowResponse
            Returns execution name of the workflow

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.internal.workflows.execute_workflow(
            application_id="applicationId",
        )
        """
        _response = self._raw_client.execute_workflow(
            application_id, inputs=inputs, inputs_literal_map=inputs_literal_map, request_options=request_options
        )
        return _response.data


class AsyncWorkflowsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkflowsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkflowsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkflowsClient
        """
        return self._raw_client

    async def execute_workflow(
        self,
        application_id: str,
        *,
        inputs: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        inputs_literal_map: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkflowsExecuteWorkflowResponse:
        """
        Execute a workflow for the specified application

        Parameters
        ----------
        application_id : str
            Id of the application

        inputs : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Workflow inputs

        inputs_literal_map : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Workflow inputs literal map

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowsExecuteWorkflowResponse
            Returns execution name of the workflow

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.internal.workflows.execute_workflow(
                application_id="applicationId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_workflow(
            application_id, inputs=inputs, inputs_literal_map=inputs_literal_map, request_options=request_options
        )
        return _response.data
