# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.delete_job_run_response import DeleteJobRunResponse
from ..types.get_job_run_response import GetJobRunResponse
from ..types.job_run import JobRun
from ..types.job_run_status import JobRunStatus
from ..types.job_runs_sort_by import JobRunsSortBy
from ..types.metadata import Metadata
from ..types.sort_direction import SortDirection
from ..types.terminate_job_response import TerminateJobResponse
from ..types.trigger_job_run_response import TriggerJobRunResponse
from .raw_client import AsyncRawJobsClient, RawJobsClient
from .types.trigger_job_request_input import TriggerJobRequestInput

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class JobsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawJobsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawJobsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawJobsClient
        """
        return self._raw_client

    def list_runs(
        self,
        job_id: str,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        search_prefix: typing.Optional[str] = None,
        sort_by: typing.Optional[JobRunsSortBy] = None,
        order: typing.Optional[SortDirection] = None,
        triggered_by: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[typing.Union[JobRunStatus, typing.Sequence[JobRunStatus]]] = None,
        version_numbers: typing.Optional[typing.Union[float, typing.Sequence[float]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[JobRun]:
        """
        List Job Runs for provided Job Id. Filter the data based on parameters passed in the query

        Parameters
        ----------
        job_id : str
            Job id of the application

        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        search_prefix : typing.Optional[str]
            Prefix used to search for job runs by name or identifier

        sort_by : typing.Optional[JobRunsSortBy]
            Attribute to sort by

        order : typing.Optional[SortDirection]
            Sorting order

        triggered_by : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Array of subject slugs

        status : typing.Optional[typing.Union[JobRunStatus, typing.Sequence[JobRunStatus]]]
            Status of the job run

        version_numbers : typing.Optional[typing.Union[float, typing.Sequence[float]]]
            Version number of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[JobRun]
            Returns all runs of a Job sorted by creation date in "data" key and total count in "totalCount" key

        Examples
        --------
        from truefoundry_sdk import JobRunsSortBy, SortDirection, TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.jobs.list_runs(
            job_id="jobId",
            limit=10,
            offset=0,
            search_prefix="searchPrefix",
            sort_by=JobRunsSortBy.START_TIME,
            order=SortDirection.ASC,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list_runs(
            job_id,
            limit=limit,
            offset=offset,
            search_prefix=search_prefix,
            sort_by=sort_by,
            order=order,
            triggered_by=triggered_by,
            status=status,
            version_numbers=version_numbers,
            request_options=request_options,
        )

    def get_run(
        self, job_id: str, job_run_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetJobRunResponse:
        """
        Get Job Run for provided jobRunName and jobId

        Parameters
        ----------
        job_id : str
            Application Id of JOB

        job_run_name : str
            Job run name of the application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetJobRunResponse
            Return JobRun details of the provided jobRunName

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.jobs.get_run(
            job_id="jobId",
            job_run_name="jobRunName",
        )
        """
        _response = self._raw_client.get_run(job_id, job_run_name, request_options=request_options)
        return _response.data

    def delete_run(
        self, job_id: str, job_run_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteJobRunResponse:
        """
        Delete Job Run for provided jobRunName and jobId

        Parameters
        ----------
        job_id : str
            Application Id of JOB

        job_run_name : str
            Job run name of the application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteJobRunResponse
            Job Run deleted

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.jobs.delete_run(
            job_id="jobId",
            job_run_name="jobRunName",
        )
        """
        _response = self._raw_client.delete_run(job_id, job_run_name, request_options=request_options)
        return _response.data

    def trigger(
        self,
        *,
        deployment_id: typing.Optional[str] = OMIT,
        application_id: typing.Optional[str] = OMIT,
        input: typing.Optional[TriggerJobRequestInput] = OMIT,
        metadata: typing.Optional[Metadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TriggerJobRunResponse:
        """
        Trigger Job for provided deploymentId or applicationId

        Parameters
        ----------
        deployment_id : typing.Optional[str]
            Deployment Id of the job

        application_id : typing.Optional[str]
            Application Id of the job

        input : typing.Optional[TriggerJobRequestInput]
            Job trigger input

        metadata : typing.Optional[Metadata]
            Metadata for the job run including job_alias_name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TriggerJobRunResponse
            Returns object with message, JobRun Name And Job Details on successful creation of Job

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.jobs.trigger()
        """
        _response = self._raw_client.trigger(
            deployment_id=deployment_id,
            application_id=application_id,
            input=input,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def terminate(
        self, *, deployment_id: str, job_run_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> TerminateJobResponse:
        """
        Terminate Job for provided deploymentId and jobRunName

        Parameters
        ----------
        deployment_id : str
            Deployment Id of the Deployment

        job_run_name : str
            Job Run name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TerminateJobResponse
            Returns object with message and JobRun Status on successful termination of Job

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.jobs.terminate(
            deployment_id="deploymentId",
            job_run_name="jobRunName",
        )
        """
        _response = self._raw_client.terminate(
            deployment_id=deployment_id, job_run_name=job_run_name, request_options=request_options
        )
        return _response.data


class AsyncJobsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawJobsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawJobsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawJobsClient
        """
        return self._raw_client

    async def list_runs(
        self,
        job_id: str,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        search_prefix: typing.Optional[str] = None,
        sort_by: typing.Optional[JobRunsSortBy] = None,
        order: typing.Optional[SortDirection] = None,
        triggered_by: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[typing.Union[JobRunStatus, typing.Sequence[JobRunStatus]]] = None,
        version_numbers: typing.Optional[typing.Union[float, typing.Sequence[float]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[JobRun]:
        """
        List Job Runs for provided Job Id. Filter the data based on parameters passed in the query

        Parameters
        ----------
        job_id : str
            Job id of the application

        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        search_prefix : typing.Optional[str]
            Prefix used to search for job runs by name or identifier

        sort_by : typing.Optional[JobRunsSortBy]
            Attribute to sort by

        order : typing.Optional[SortDirection]
            Sorting order

        triggered_by : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Array of subject slugs

        status : typing.Optional[typing.Union[JobRunStatus, typing.Sequence[JobRunStatus]]]
            Status of the job run

        version_numbers : typing.Optional[typing.Union[float, typing.Sequence[float]]]
            Version number of the deployment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[JobRun]
            Returns all runs of a Job sorted by creation date in "data" key and total count in "totalCount" key

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry, JobRunsSortBy, SortDirection

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.jobs.list_runs(
                job_id="jobId",
                limit=10,
                offset=0,
                search_prefix="searchPrefix",
                sort_by=JobRunsSortBy.START_TIME,
                order=SortDirection.ASC,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list_runs(
            job_id,
            limit=limit,
            offset=offset,
            search_prefix=search_prefix,
            sort_by=sort_by,
            order=order,
            triggered_by=triggered_by,
            status=status,
            version_numbers=version_numbers,
            request_options=request_options,
        )

    async def get_run(
        self, job_id: str, job_run_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetJobRunResponse:
        """
        Get Job Run for provided jobRunName and jobId

        Parameters
        ----------
        job_id : str
            Application Id of JOB

        job_run_name : str
            Job run name of the application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetJobRunResponse
            Return JobRun details of the provided jobRunName

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.jobs.get_run(
                job_id="jobId",
                job_run_name="jobRunName",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_run(job_id, job_run_name, request_options=request_options)
        return _response.data

    async def delete_run(
        self, job_id: str, job_run_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteJobRunResponse:
        """
        Delete Job Run for provided jobRunName and jobId

        Parameters
        ----------
        job_id : str
            Application Id of JOB

        job_run_name : str
            Job run name of the application

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteJobRunResponse
            Job Run deleted

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.jobs.delete_run(
                job_id="jobId",
                job_run_name="jobRunName",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_run(job_id, job_run_name, request_options=request_options)
        return _response.data

    async def trigger(
        self,
        *,
        deployment_id: typing.Optional[str] = OMIT,
        application_id: typing.Optional[str] = OMIT,
        input: typing.Optional[TriggerJobRequestInput] = OMIT,
        metadata: typing.Optional[Metadata] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TriggerJobRunResponse:
        """
        Trigger Job for provided deploymentId or applicationId

        Parameters
        ----------
        deployment_id : typing.Optional[str]
            Deployment Id of the job

        application_id : typing.Optional[str]
            Application Id of the job

        input : typing.Optional[TriggerJobRequestInput]
            Job trigger input

        metadata : typing.Optional[Metadata]
            Metadata for the job run including job_alias_name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TriggerJobRunResponse
            Returns object with message, JobRun Name And Job Details on successful creation of Job

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.jobs.trigger()


        asyncio.run(main())
        """
        _response = await self._raw_client.trigger(
            deployment_id=deployment_id,
            application_id=application_id,
            input=input,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def terminate(
        self, *, deployment_id: str, job_run_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> TerminateJobResponse:
        """
        Terminate Job for provided deploymentId and jobRunName

        Parameters
        ----------
        deployment_id : str
            Deployment Id of the Deployment

        job_run_name : str
            Job Run name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TerminateJobResponse
            Returns object with message and JobRun Status on successful termination of Job

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.jobs.terminate(
                deployment_id="deploymentId",
                job_run_name="jobRunName",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.terminate(
            deployment_id=deployment_id, job_run_name=job_run_name, request_options=request_options
        )
        return _response.data
