# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.get_logs_response import GetLogsResponse
from ..types.logs_search_filter_type import LogsSearchFilterType
from ..types.logs_search_operator_type import LogsSearchOperatorType
from ..types.logs_sorting_direction import LogsSortingDirection
from .raw_client import AsyncRawLogsClient, RawLogsClient


class LogsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawLogsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawLogsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawLogsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        start_ts: typing.Optional[int] = None,
        end_ts: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        direction: typing.Optional[LogsSortingDirection] = None,
        num_logs_to_ignore: typing.Optional[int] = None,
        application_id: typing.Optional[str] = None,
        application_fqn: typing.Optional[str] = None,
        deployment_id: typing.Optional[str] = None,
        job_run_name: typing.Optional[str] = None,
        pod_name: typing.Optional[str] = None,
        container_name: typing.Optional[str] = None,
        pod_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        pod_names_regex: typing.Optional[str] = None,
        search_filters: typing.Optional[str] = None,
        search_string: typing.Optional[str] = None,
        search_type: typing.Optional[LogsSearchFilterType] = None,
        search_operator: typing.Optional[LogsSearchOperatorType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetLogsResponse:
        """
        Fetch logs for various workload components, including Services, Jobs, Workflows, Job Runs, and Pods. Logs are filtered based on the provided query parameters.

        Parameters
        ----------
        start_ts : typing.Optional[int]
            Start timestamp for querying logs, in nanoseconds from the Unix epoch.

        end_ts : typing.Optional[int]
            End timestamp for querying logs, in nanoseconds from the Unix epoch.

        limit : typing.Optional[int]
            Max number of log lines to fetch

        direction : typing.Optional[LogsSortingDirection]
            Direction of sorting logs. Can be `asc` or `desc`

        num_logs_to_ignore : typing.Optional[int]
            Number of logs corresponding to the starting timestamp to be ignored.

        application_id : typing.Optional[str]
            Application ID

        application_fqn : typing.Optional[str]
            Application FQN

        deployment_id : typing.Optional[str]
            Deployment ID

        job_run_name : typing.Optional[str]
            Name of the Job Run for which to fetch logs.

        pod_name : typing.Optional[str]
            Name of Pod for which to fetch logs.

        container_name : typing.Optional[str]
            Name of the Container for which to fetch logs.

        pod_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of pod names for which to fetch logs.

        pod_names_regex : typing.Optional[str]
            Regex pattern for pod names to fetch logs.

        search_filters : typing.Optional[str]
            JSON string containing array of search filters with string, type and operator

        search_string : typing.Optional[str]
            String that needs to be matched

        search_type : typing.Optional[LogsSearchFilterType]
            Query filter type, `regex` `substring` `ignore_case_substring`

        search_operator : typing.Optional[LogsSearchOperatorType]
            Comparison operator for filter. `equal` or `not_equal`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetLogsResponse
            Successfully retrieved logs for the workload

        Examples
        --------
        from truefoundry_sdk import (
            LogsSearchFilterType,
            LogsSearchOperatorType,
            LogsSortingDirection,
            TrueFoundry,
        )

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.logs.get(
            start_ts=1000000,
            end_ts=1000000,
            limit=1,
            direction=LogsSortingDirection.ASC,
            num_logs_to_ignore=1,
            application_id="applicationId",
            application_fqn="applicationFqn",
            deployment_id="deploymentId",
            job_run_name="jobRunName",
            pod_name="podName",
            container_name="containerName",
            pod_names_regex="podNamesRegex",
            search_filters="searchFilters",
            search_string="searchString",
            search_type=LogsSearchFilterType.REGEX,
            search_operator=LogsSearchOperatorType.EQUAL,
        )
        """
        _response = self._raw_client.get(
            start_ts=start_ts,
            end_ts=end_ts,
            limit=limit,
            direction=direction,
            num_logs_to_ignore=num_logs_to_ignore,
            application_id=application_id,
            application_fqn=application_fqn,
            deployment_id=deployment_id,
            job_run_name=job_run_name,
            pod_name=pod_name,
            container_name=container_name,
            pod_names=pod_names,
            pod_names_regex=pod_names_regex,
            search_filters=search_filters,
            search_string=search_string,
            search_type=search_type,
            search_operator=search_operator,
            request_options=request_options,
        )
        return _response.data


class AsyncLogsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawLogsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawLogsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawLogsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        start_ts: typing.Optional[int] = None,
        end_ts: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        direction: typing.Optional[LogsSortingDirection] = None,
        num_logs_to_ignore: typing.Optional[int] = None,
        application_id: typing.Optional[str] = None,
        application_fqn: typing.Optional[str] = None,
        deployment_id: typing.Optional[str] = None,
        job_run_name: typing.Optional[str] = None,
        pod_name: typing.Optional[str] = None,
        container_name: typing.Optional[str] = None,
        pod_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        pod_names_regex: typing.Optional[str] = None,
        search_filters: typing.Optional[str] = None,
        search_string: typing.Optional[str] = None,
        search_type: typing.Optional[LogsSearchFilterType] = None,
        search_operator: typing.Optional[LogsSearchOperatorType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetLogsResponse:
        """
        Fetch logs for various workload components, including Services, Jobs, Workflows, Job Runs, and Pods. Logs are filtered based on the provided query parameters.

        Parameters
        ----------
        start_ts : typing.Optional[int]
            Start timestamp for querying logs, in nanoseconds from the Unix epoch.

        end_ts : typing.Optional[int]
            End timestamp for querying logs, in nanoseconds from the Unix epoch.

        limit : typing.Optional[int]
            Max number of log lines to fetch

        direction : typing.Optional[LogsSortingDirection]
            Direction of sorting logs. Can be `asc` or `desc`

        num_logs_to_ignore : typing.Optional[int]
            Number of logs corresponding to the starting timestamp to be ignored.

        application_id : typing.Optional[str]
            Application ID

        application_fqn : typing.Optional[str]
            Application FQN

        deployment_id : typing.Optional[str]
            Deployment ID

        job_run_name : typing.Optional[str]
            Name of the Job Run for which to fetch logs.

        pod_name : typing.Optional[str]
            Name of Pod for which to fetch logs.

        container_name : typing.Optional[str]
            Name of the Container for which to fetch logs.

        pod_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of pod names for which to fetch logs.

        pod_names_regex : typing.Optional[str]
            Regex pattern for pod names to fetch logs.

        search_filters : typing.Optional[str]
            JSON string containing array of search filters with string, type and operator

        search_string : typing.Optional[str]
            String that needs to be matched

        search_type : typing.Optional[LogsSearchFilterType]
            Query filter type, `regex` `substring` `ignore_case_substring`

        search_operator : typing.Optional[LogsSearchOperatorType]
            Comparison operator for filter. `equal` or `not_equal`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetLogsResponse
            Successfully retrieved logs for the workload

        Examples
        --------
        import asyncio

        from truefoundry_sdk import (
            AsyncTrueFoundry,
            LogsSearchFilterType,
            LogsSearchOperatorType,
            LogsSortingDirection,
        )

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.logs.get(
                start_ts=1000000,
                end_ts=1000000,
                limit=1,
                direction=LogsSortingDirection.ASC,
                num_logs_to_ignore=1,
                application_id="applicationId",
                application_fqn="applicationFqn",
                deployment_id="deploymentId",
                job_run_name="jobRunName",
                pod_name="podName",
                container_name="containerName",
                pod_names_regex="podNamesRegex",
                search_filters="searchFilters",
                search_string="searchString",
                search_type=LogsSearchFilterType.REGEX,
                search_operator=LogsSearchOperatorType.EQUAL,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            start_ts=start_ts,
            end_ts=end_ts,
            limit=limit,
            direction=direction,
            num_logs_to_ignore=num_logs_to_ignore,
            application_id=application_id,
            application_fqn=application_fqn,
            deployment_id=deployment_id,
            job_run_name=job_run_name,
            pod_name=pod_name,
            container_name=container_name,
            pod_names=pod_names,
            pod_names_regex=pod_names_regex,
            search_filters=search_filters,
            search_string=search_string,
            search_type=search_type,
            search_operator=search_operator,
            request_options=request_options,
        )
        return _response.data
