# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..types.get_logs_response import GetLogsResponse
from ..types.logs_search_filter_type import LogsSearchFilterType
from ..types.logs_search_operator_type import LogsSearchOperatorType
from ..types.logs_sorting_direction import LogsSortingDirection


class RawLogsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        *,
        start_ts: typing.Optional[int] = None,
        end_ts: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        direction: typing.Optional[LogsSortingDirection] = None,
        num_logs_to_ignore: typing.Optional[int] = None,
        application_id: typing.Optional[str] = None,
        application_fqn: typing.Optional[str] = None,
        deployment_id: typing.Optional[str] = None,
        job_run_name: typing.Optional[str] = None,
        pod_name: typing.Optional[str] = None,
        container_name: typing.Optional[str] = None,
        pod_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        pod_names_regex: typing.Optional[str] = None,
        search_filters: typing.Optional[str] = None,
        search_string: typing.Optional[str] = None,
        search_type: typing.Optional[LogsSearchFilterType] = None,
        search_operator: typing.Optional[LogsSearchOperatorType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetLogsResponse]:
        """
        Fetch logs for various workload components, including Services, Jobs, Workflows, Job Runs, and Pods. Logs are filtered based on the provided query parameters.

        Parameters
        ----------
        start_ts : typing.Optional[int]
            Start timestamp for querying logs, in nanoseconds from the Unix epoch.

        end_ts : typing.Optional[int]
            End timestamp for querying logs, in nanoseconds from the Unix epoch.

        limit : typing.Optional[int]
            Max number of log lines to fetch

        direction : typing.Optional[LogsSortingDirection]
            Direction of sorting logs. Can be `asc` or `desc`

        num_logs_to_ignore : typing.Optional[int]
            Number of logs corresponding to the starting timestamp to be ignored.

        application_id : typing.Optional[str]
            Application ID

        application_fqn : typing.Optional[str]
            Application FQN

        deployment_id : typing.Optional[str]
            Deployment ID

        job_run_name : typing.Optional[str]
            Name of the Job Run for which to fetch logs.

        pod_name : typing.Optional[str]
            Name of Pod for which to fetch logs.

        container_name : typing.Optional[str]
            Name of the Container for which to fetch logs.

        pod_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of pod names for which to fetch logs.

        pod_names_regex : typing.Optional[str]
            Regex pattern for pod names to fetch logs.

        search_filters : typing.Optional[str]
            JSON string containing array of search filters with string, type and operator

        search_string : typing.Optional[str]
            String that needs to be matched

        search_type : typing.Optional[LogsSearchFilterType]
            Query filter type, `regex` `substring` `ignore_case_substring`

        search_operator : typing.Optional[LogsSearchOperatorType]
            Comparison operator for filter. `equal` or `not_equal`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetLogsResponse]
            Successfully retrieved logs for the workload
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/svc/v1/logs",
            method="GET",
            params={
                "startTs": start_ts,
                "endTs": end_ts,
                "limit": limit,
                "direction": direction,
                "numLogsToIgnore": num_logs_to_ignore,
                "applicationId": application_id,
                "applicationFqn": application_fqn,
                "deploymentId": deployment_id,
                "jobRunName": job_run_name,
                "podName": pod_name,
                "containerName": container_name,
                "podNames": pod_names,
                "podNamesRegex": pod_names_regex,
                "searchFilters": search_filters,
                "searchString": search_string,
                "searchType": search_type,
                "searchOperator": search_operator,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetLogsResponse,
                    parse_obj_as(
                        type_=GetLogsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawLogsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        *,
        start_ts: typing.Optional[int] = None,
        end_ts: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        direction: typing.Optional[LogsSortingDirection] = None,
        num_logs_to_ignore: typing.Optional[int] = None,
        application_id: typing.Optional[str] = None,
        application_fqn: typing.Optional[str] = None,
        deployment_id: typing.Optional[str] = None,
        job_run_name: typing.Optional[str] = None,
        pod_name: typing.Optional[str] = None,
        container_name: typing.Optional[str] = None,
        pod_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        pod_names_regex: typing.Optional[str] = None,
        search_filters: typing.Optional[str] = None,
        search_string: typing.Optional[str] = None,
        search_type: typing.Optional[LogsSearchFilterType] = None,
        search_operator: typing.Optional[LogsSearchOperatorType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetLogsResponse]:
        """
        Fetch logs for various workload components, including Services, Jobs, Workflows, Job Runs, and Pods. Logs are filtered based on the provided query parameters.

        Parameters
        ----------
        start_ts : typing.Optional[int]
            Start timestamp for querying logs, in nanoseconds from the Unix epoch.

        end_ts : typing.Optional[int]
            End timestamp for querying logs, in nanoseconds from the Unix epoch.

        limit : typing.Optional[int]
            Max number of log lines to fetch

        direction : typing.Optional[LogsSortingDirection]
            Direction of sorting logs. Can be `asc` or `desc`

        num_logs_to_ignore : typing.Optional[int]
            Number of logs corresponding to the starting timestamp to be ignored.

        application_id : typing.Optional[str]
            Application ID

        application_fqn : typing.Optional[str]
            Application FQN

        deployment_id : typing.Optional[str]
            Deployment ID

        job_run_name : typing.Optional[str]
            Name of the Job Run for which to fetch logs.

        pod_name : typing.Optional[str]
            Name of Pod for which to fetch logs.

        container_name : typing.Optional[str]
            Name of the Container for which to fetch logs.

        pod_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of pod names for which to fetch logs.

        pod_names_regex : typing.Optional[str]
            Regex pattern for pod names to fetch logs.

        search_filters : typing.Optional[str]
            JSON string containing array of search filters with string, type and operator

        search_string : typing.Optional[str]
            String that needs to be matched

        search_type : typing.Optional[LogsSearchFilterType]
            Query filter type, `regex` `substring` `ignore_case_substring`

        search_operator : typing.Optional[LogsSearchOperatorType]
            Comparison operator for filter. `equal` or `not_equal`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetLogsResponse]
            Successfully retrieved logs for the workload
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/svc/v1/logs",
            method="GET",
            params={
                "startTs": start_ts,
                "endTs": end_ts,
                "limit": limit,
                "direction": direction,
                "numLogsToIgnore": num_logs_to_ignore,
                "applicationId": application_id,
                "applicationFqn": application_fqn,
                "deploymentId": deployment_id,
                "jobRunName": job_run_name,
                "podName": pod_name,
                "containerName": container_name,
                "podNames": pod_names,
                "podNamesRegex": pod_names_regex,
                "searchFilters": search_filters,
                "searchString": search_string,
                "searchType": search_type,
                "searchOperator": search_operator,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetLogsResponse,
                    parse_obj_as(
                        type_=GetLogsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
