# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.empty_response import EmptyResponse
from ..types.get_prompt_version_response import GetPromptVersionResponse
from ..types.prompt_version import PromptVersion
from .raw_client import AsyncRawPromptVersionsClient, RawPromptVersionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PromptVersionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPromptVersionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPromptVersionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPromptVersionsClient
        """
        return self._raw_client

    def apply_tags(
        self,
        *,
        prompt_version_id: str,
        tags: typing.Sequence[str],
        force: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EmptyResponse:
        """
        Parameters
        ----------
        prompt_version_id : str

        tags : typing.Sequence[str]

        force : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmptyResponse
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.prompt_versions.apply_tags(
            prompt_version_id="prompt_version_id",
            tags=["tags"],
        )
        """
        _response = self._raw_client.apply_tags(
            prompt_version_id=prompt_version_id, tags=tags, force=force, request_options=request_options
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetPromptVersionResponse:
        """
        Get prompt version API

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetPromptVersionResponse
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.prompt_versions.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> EmptyResponse:
        """
        Delete prompt versions API

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmptyResponse
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.prompt_versions.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def list(
        self,
        *,
        tag: typing.Optional[str] = None,
        fqn: typing.Optional[str] = None,
        prompt_id: typing.Optional[str] = None,
        ml_repo_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        version: typing.Optional[int] = None,
        offset: typing.Optional[int] = 0,
        limit: typing.Optional[int] = 100,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[PromptVersion]:
        """
        List prompt version API

        Parameters
        ----------
        tag : typing.Optional[str]

        fqn : typing.Optional[str]

        prompt_id : typing.Optional[str]

        ml_repo_id : typing.Optional[str]

        name : typing.Optional[str]

        version : typing.Optional[int]

        offset : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[PromptVersion]
            Successful Response

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.prompt_versions.list(
            tag="tag",
            fqn="fqn",
            prompt_id="prompt_id",
            ml_repo_id="ml_repo_id",
            name="name",
            version=1,
            offset=1,
            limit=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            tag=tag,
            fqn=fqn,
            prompt_id=prompt_id,
            ml_repo_id=ml_repo_id,
            name=name,
            version=version,
            offset=offset,
            limit=limit,
            request_options=request_options,
        )


class AsyncPromptVersionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPromptVersionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPromptVersionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPromptVersionsClient
        """
        return self._raw_client

    async def apply_tags(
        self,
        *,
        prompt_version_id: str,
        tags: typing.Sequence[str],
        force: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EmptyResponse:
        """
        Parameters
        ----------
        prompt_version_id : str

        tags : typing.Sequence[str]

        force : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmptyResponse
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.prompt_versions.apply_tags(
                prompt_version_id="prompt_version_id",
                tags=["tags"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.apply_tags(
            prompt_version_id=prompt_version_id, tags=tags, force=force, request_options=request_options
        )
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetPromptVersionResponse:
        """
        Get prompt version API

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetPromptVersionResponse
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.prompt_versions.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> EmptyResponse:
        """
        Delete prompt versions API

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmptyResponse
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.prompt_versions.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def list(
        self,
        *,
        tag: typing.Optional[str] = None,
        fqn: typing.Optional[str] = None,
        prompt_id: typing.Optional[str] = None,
        ml_repo_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        version: typing.Optional[int] = None,
        offset: typing.Optional[int] = 0,
        limit: typing.Optional[int] = 100,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[PromptVersion]:
        """
        List prompt version API

        Parameters
        ----------
        tag : typing.Optional[str]

        fqn : typing.Optional[str]

        prompt_id : typing.Optional[str]

        ml_repo_id : typing.Optional[str]

        name : typing.Optional[str]

        version : typing.Optional[int]

        offset : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[PromptVersion]
            Successful Response

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.prompt_versions.list(
                tag="tag",
                fqn="fqn",
                prompt_id="prompt_id",
                ml_repo_id="ml_repo_id",
                name="name",
                version=1,
                offset=1,
                limit=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            tag=tag,
            fqn=fqn,
            prompt_id=prompt_id,
            ml_repo_id=ml_repo_id,
            name=name,
            version=version,
            offset=offset,
            limit=limit,
            request_options=request_options,
        )
