# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.http_response import AsyncHttpResponse, HttpResponse
from .core.pydantic_utilities import parse_obj_as
from .core.request_options import RequestOptions
from .core.serialization import convert_and_respect_annotation_metadata
from .types.true_foundry_apply_request_manifest import TrueFoundryApplyRequestManifest
from .types.true_foundry_apply_response import TrueFoundryApplyResponse
from .types.true_foundry_delete_request_manifest import TrueFoundryDeleteRequestManifest

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawBaseTrueFoundry:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def apply(
        self,
        *,
        manifest: TrueFoundryApplyRequestManifest,
        dry_run: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[TrueFoundryApplyResponse]:
        """
        Applies a given manifest to create or update resources of specific types, such as provider-account, cluster, workspace, or ml-repo.

        Parameters
        ----------
        manifest : TrueFoundryApplyRequestManifest
            manifest of the resource to be created or updated

        dry_run : typing.Optional[bool]
            Dry run the apply operation without actually applying

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TrueFoundryApplyResponse]
            The resource has been successfully created or updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/svc/v1/apply",
            method="PUT",
            json={
                "manifest": convert_and_respect_annotation_metadata(
                    object_=manifest, annotation=TrueFoundryApplyRequestManifest, direction="write"
                ),
                "dryRun": dry_run,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TrueFoundryApplyResponse,
                    parse_obj_as(
                        type_=TrueFoundryApplyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, *, manifest: TrueFoundryDeleteRequestManifest, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Deletes resources of specific types, such as provider-account, cluster, workspace, or application.

        Parameters
        ----------
        manifest : TrueFoundryDeleteRequestManifest
            manifest of the resource to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/svc/v1/delete",
            method="POST",
            json={
                "manifest": convert_and_respect_annotation_metadata(
                    object_=manifest, annotation=TrueFoundryDeleteRequestManifest, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawBaseTrueFoundry:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def apply(
        self,
        *,
        manifest: TrueFoundryApplyRequestManifest,
        dry_run: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[TrueFoundryApplyResponse]:
        """
        Applies a given manifest to create or update resources of specific types, such as provider-account, cluster, workspace, or ml-repo.

        Parameters
        ----------
        manifest : TrueFoundryApplyRequestManifest
            manifest of the resource to be created or updated

        dry_run : typing.Optional[bool]
            Dry run the apply operation without actually applying

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TrueFoundryApplyResponse]
            The resource has been successfully created or updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/svc/v1/apply",
            method="PUT",
            json={
                "manifest": convert_and_respect_annotation_metadata(
                    object_=manifest, annotation=TrueFoundryApplyRequestManifest, direction="write"
                ),
                "dryRun": dry_run,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TrueFoundryApplyResponse,
                    parse_obj_as(
                        type_=TrueFoundryApplyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, *, manifest: TrueFoundryDeleteRequestManifest, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Deletes resources of specific types, such as provider-account, cluster, workspace, or application.

        Parameters
        ----------
        manifest : TrueFoundryDeleteRequestManifest
            manifest of the resource to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/svc/v1/delete",
            method="POST",
            json={
                "manifest": convert_and_respect_annotation_metadata(
                    object_=manifest, annotation=TrueFoundryDeleteRequestManifest, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
