# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.delete_secret_group_response import DeleteSecretGroupResponse
from ..types.get_secret_group_response import GetSecretGroupResponse
from ..types.secret_group import SecretGroup
from ..types.secret_input import SecretInput
from ..types.update_secret_input import UpdateSecretInput
from .raw_client import AsyncRawSecretGroupsClient, RawSecretGroupsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SecretGroupsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSecretGroupsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSecretGroupsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSecretGroupsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        fqn: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[SecretGroup]:
        """
        List the secret groups associated with a user along with the associated secrets for each group. Filtered with the options passed in the query fields. Note: This method does not return the secret values of the <em>associatedSecrets</em> in the response. A separate API call to `/v1/secrets/{id}` should be made to fetch the associated secret value.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        fqn : typing.Optional[str]
            Fqn of secret group.

        search : typing.Optional[str]
            Search query - filters by secret group names that contain the search string

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[SecretGroup]
            Returns all the secret groups associated with a user along with the associated secrets for each group.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.secret_groups.list(
            limit=10,
            offset=0,
            fqn="fqn",
            search="search",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            limit=limit, offset=offset, fqn=fqn, search=search, request_options=request_options
        )

    def create(
        self,
        *,
        name: str,
        integration_id: str,
        secrets: typing.Sequence[SecretInput],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetSecretGroupResponse:
        """
        Creates a secret group with secrets in it. A secret version for each of the created secret is created with version number as 1. The returned secret group does not have any secret values in the <em>associatedSecrets</em> field. A separate API call to `/v1/secrets/{id}` should be made to fetch the associated secret value.

        Parameters
        ----------
        name : str
            Name of the secret group.

        integration_id : str
            Id of the provider integration.

        secrets : typing.Sequence[SecretInput]
            The secrets to be associated with the secret group

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSecretGroupResponse
            Returns the created secret group without the associated secrets.

        Examples
        --------
        from truefoundry_sdk import SecretInput, TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.secret_groups.create(
            name="name",
            integration_id="integrationId",
            secrets=[
                SecretInput(
                    key="key",
                    value="value",
                )
            ],
        )
        """
        _response = self._raw_client.create(
            name=name, integration_id=integration_id, secrets=secrets, request_options=request_options
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetSecretGroupResponse:
        """
        Get Secret Group by id. This method does not return the secret values of the <em>associatedSecrets</em> in the response. A separate API call to `/v1/secrets/{id}` should be made to fetch the associated secret value.

        Parameters
        ----------
        id : str
            Secret Id of the secret group.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSecretGroupResponse
            Returns the Secret Group associated with provided id

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.secret_groups.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        secrets: typing.Sequence[UpdateSecretInput],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetSecretGroupResponse:
        """
        Updates the secrets in a secret group with new values. A new secret version is created for every secret that has a modified value and any omitted secrets are deleted. The returned updated secret group does not have any secret values in the <em>associatedSecrets</em> field. A separate API call to `/v1/secrets/{id}` should be made to fetch the associated secret value.

        Parameters
        ----------
        id : str
            Secret Id of the secret group.

        secrets : typing.Sequence[UpdateSecretInput]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSecretGroupResponse
            Returns the updated secret group without associated secrets.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry, UpdateSecretInput

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.secret_groups.update(
            id="id",
            secrets=[
                UpdateSecretInput(
                    key="key",
                )
            ],
        )
        """
        _response = self._raw_client.update(id, secrets=secrets, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DeleteSecretGroupResponse:
        """
        Deletes the secret group, its associated secrets and secret versions of those secrets.

        Parameters
        ----------
        id : str
            Secret Id of the secret group.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteSecretGroupResponse
            Deletes Secret Group.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.secret_groups.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data


class AsyncSecretGroupsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSecretGroupsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSecretGroupsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSecretGroupsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        fqn: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[SecretGroup]:
        """
        List the secret groups associated with a user along with the associated secrets for each group. Filtered with the options passed in the query fields. Note: This method does not return the secret values of the <em>associatedSecrets</em> in the response. A separate API call to `/v1/secrets/{id}` should be made to fetch the associated secret value.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        fqn : typing.Optional[str]
            Fqn of secret group.

        search : typing.Optional[str]
            Search query - filters by secret group names that contain the search string

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[SecretGroup]
            Returns all the secret groups associated with a user along with the associated secrets for each group.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.secret_groups.list(
                limit=10,
                offset=0,
                fqn="fqn",
                search="search",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            limit=limit, offset=offset, fqn=fqn, search=search, request_options=request_options
        )

    async def create(
        self,
        *,
        name: str,
        integration_id: str,
        secrets: typing.Sequence[SecretInput],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetSecretGroupResponse:
        """
        Creates a secret group with secrets in it. A secret version for each of the created secret is created with version number as 1. The returned secret group does not have any secret values in the <em>associatedSecrets</em> field. A separate API call to `/v1/secrets/{id}` should be made to fetch the associated secret value.

        Parameters
        ----------
        name : str
            Name of the secret group.

        integration_id : str
            Id of the provider integration.

        secrets : typing.Sequence[SecretInput]
            The secrets to be associated with the secret group

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSecretGroupResponse
            Returns the created secret group without the associated secrets.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry, SecretInput

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.secret_groups.create(
                name="name",
                integration_id="integrationId",
                secrets=[
                    SecretInput(
                        key="key",
                        value="value",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name, integration_id=integration_id, secrets=secrets, request_options=request_options
        )
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetSecretGroupResponse:
        """
        Get Secret Group by id. This method does not return the secret values of the <em>associatedSecrets</em> in the response. A separate API call to `/v1/secrets/{id}` should be made to fetch the associated secret value.

        Parameters
        ----------
        id : str
            Secret Id of the secret group.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSecretGroupResponse
            Returns the Secret Group associated with provided id

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.secret_groups.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        secrets: typing.Sequence[UpdateSecretInput],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetSecretGroupResponse:
        """
        Updates the secrets in a secret group with new values. A new secret version is created for every secret that has a modified value and any omitted secrets are deleted. The returned updated secret group does not have any secret values in the <em>associatedSecrets</em> field. A separate API call to `/v1/secrets/{id}` should be made to fetch the associated secret value.

        Parameters
        ----------
        id : str
            Secret Id of the secret group.

        secrets : typing.Sequence[UpdateSecretInput]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSecretGroupResponse
            Returns the updated secret group without associated secrets.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry, UpdateSecretInput

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.secret_groups.update(
                id="id",
                secrets=[
                    UpdateSecretInput(
                        key="key",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(id, secrets=secrets, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteSecretGroupResponse:
        """
        Deletes the secret group, its associated secrets and secret versions of those secrets.

        Parameters
        ----------
        id : str
            Secret Id of the secret group.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteSecretGroupResponse
            Deletes Secret Group.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.secret_groups.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data
