# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.get_secret_response import GetSecretResponse
from ..types.secret import Secret
from .raw_client import AsyncRawSecretsClient, RawSecretsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SecretsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSecretsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSecretsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSecretsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        secret_fqns: typing.Optional[typing.Sequence[str]] = OMIT,
        secret_group_id: typing.Optional[str] = OMIT,
        with_value: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Secret]:
        """
        List secrets associated with a user filtered with optional parameters passed in the body.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        secret_fqns : typing.Optional[typing.Sequence[str]]
            Array of FQNs

        secret_group_id : typing.Optional[str]
            Secret Group Id of the secret gourp.

        with_value : typing.Optional[bool]
            Whether to include the secret values in the response. Defaults to false.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Secret]
            Returns the secrets associated with a user filtered with optional parameters passed in the body.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.secrets.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            limit=limit,
            offset=offset,
            secret_fqns=secret_fqns,
            secret_group_id=secret_group_id,
            with_value=with_value,
            request_options=request_options,
        )

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetSecretResponse:
        """
        Get Secret associated with provided id. The secret value is not returned if the control plane has `DISABLE_SECRET_VALUE_VIEW` set

        Parameters
        ----------
        id : str
            Secret Id of the secret.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSecretResponse
            Returns the Secret associated with provided id

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.secrets.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> float:
        """
        Deletes a secret and its versions along with its values.

        Parameters
        ----------
        id : str
            Secret Id of the secret.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        float
            Deletes a secret and its versions along with its values and returns the count of the deleted secrets.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.secrets.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data


class AsyncSecretsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSecretsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSecretsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSecretsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        secret_fqns: typing.Optional[typing.Sequence[str]] = OMIT,
        secret_group_id: typing.Optional[str] = OMIT,
        with_value: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Secret]:
        """
        List secrets associated with a user filtered with optional parameters passed in the body.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        secret_fqns : typing.Optional[typing.Sequence[str]]
            Array of FQNs

        secret_group_id : typing.Optional[str]
            Secret Group Id of the secret gourp.

        with_value : typing.Optional[bool]
            Whether to include the secret values in the response. Defaults to false.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Secret]
            Returns the secrets associated with a user filtered with optional parameters passed in the body.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.secrets.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            limit=limit,
            offset=offset,
            secret_fqns=secret_fqns,
            secret_group_id=secret_group_id,
            with_value=with_value,
            request_options=request_options,
        )

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetSecretResponse:
        """
        Get Secret associated with provided id. The secret value is not returned if the control plane has `DISABLE_SECRET_VALUE_VIEW` set

        Parameters
        ----------
        id : str
            Secret Id of the secret.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSecretResponse
            Returns the Secret associated with provided id

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.secrets.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> float:
        """
        Deletes a secret and its versions along with its values.

        Parameters
        ----------
        id : str
            Secret Id of the secret.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        float
            Deletes a secret and its versions along with its values and returns the count of the deleted secrets.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.secrets.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data
