# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.delete_team_response import DeleteTeamResponse
from ..types.get_team_response import GetTeamResponse
from ..types.team import Team
from .raw_client import AsyncRawTeamsClient, RawTeamsClient
from .types.apply_team_request_manifest import ApplyTeamRequestManifest
from .types.teams_list_request_type import TeamsListRequestType

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TeamsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTeamsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTeamsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTeamsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        type: typing.Optional[TeamsListRequestType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Team]:
        """
        Retrieve all teams associated with the authenticated user. If the user is a tenant admin, returns all teams for the tenant. Pagination is available based on query parameters

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        type : typing.Optional[TeamsListRequestType]
            Filter teams by type

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Team]
            Returns an array of teams associated with the user or tenant And also the response includes paginated data

        Examples
        --------
        from truefoundry_sdk import TrueFoundry
        from truefoundry_sdk.teams import TeamsListRequestType

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.teams.list(
            limit=10,
            offset=0,
            type=TeamsListRequestType.TEAM,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(limit=limit, offset=offset, type=type, request_options=request_options)

    def create_or_update(
        self,
        *,
        manifest: ApplyTeamRequestManifest,
        dry_run: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetTeamResponse:
        """
        Creates a new team or updates an existing team. It ensures that the team name is unique, valid, and that the team has at least one member. The members of the team are added or updated based on the provided emails.

        Parameters
        ----------
        manifest : ApplyTeamRequestManifest
            Team manifest

        dry_run : typing.Optional[bool]
            Dry run

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTeamResponse
            Returns the created or updated team.

        Examples
        --------
        from truefoundry_sdk import TeamManifest, TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.teams.create_or_update(
            manifest=TeamManifest(
                name="name",
                members=["members"],
            ),
        )
        """
        _response = self._raw_client.create_or_update(
            manifest=manifest, dry_run=dry_run, request_options=request_options
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetTeamResponse:
        """
        Get Team associated with provided team id

        Parameters
        ----------
        id : str
            Team Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTeamResponse
            Returns the Team associated with provided team id

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.teams.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DeleteTeamResponse:
        """
        Deletes the Team associated with the provided Id.

        Parameters
        ----------
        id : str
            Team Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteTeamResponse
            Successfully deleted the team.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.teams.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data


class AsyncTeamsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTeamsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTeamsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTeamsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        type: typing.Optional[TeamsListRequestType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Team]:
        """
        Retrieve all teams associated with the authenticated user. If the user is a tenant admin, returns all teams for the tenant. Pagination is available based on query parameters

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        type : typing.Optional[TeamsListRequestType]
            Filter teams by type

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Team]
            Returns an array of teams associated with the user or tenant And also the response includes paginated data

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry
        from truefoundry_sdk.teams import TeamsListRequestType

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.teams.list(
                limit=10,
                offset=0,
                type=TeamsListRequestType.TEAM,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(limit=limit, offset=offset, type=type, request_options=request_options)

    async def create_or_update(
        self,
        *,
        manifest: ApplyTeamRequestManifest,
        dry_run: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetTeamResponse:
        """
        Creates a new team or updates an existing team. It ensures that the team name is unique, valid, and that the team has at least one member. The members of the team are added or updated based on the provided emails.

        Parameters
        ----------
        manifest : ApplyTeamRequestManifest
            Team manifest

        dry_run : typing.Optional[bool]
            Dry run

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTeamResponse
            Returns the created or updated team.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry, TeamManifest

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.teams.create_or_update(
                manifest=TeamManifest(
                    name="name",
                    members=["members"],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update(
            manifest=manifest, dry_run=dry_run, request_options=request_options
        )
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetTeamResponse:
        """
        Get Team associated with provided team id

        Parameters
        ----------
        id : str
            Team Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTeamResponse
            Returns the Team associated with provided team id

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.teams.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DeleteTeamResponse:
        """
        Deletes the Team associated with the provided Id.

        Parameters
        ----------
        id : str
            Team Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteTeamResponse
            Successfully deleted the team.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.teams.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data
