# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from ..core.serialization import FieldMetadata
from .add_on_component_source import AddOnComponentSource
from .addon_component_name import AddonComponentName
from .addon_component_status import AddonComponentStatus
from .cluster_type import ClusterType
from .recommendation import Recommendation
from .upgrade_data import UpgradeData


class AddonComponent(UniversalBaseModel):
    name: AddonComponentName
    app_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="appName")] = None
    namespace: typing.Optional[str] = None
    application_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="applicationId")] = None
    description: typing.Optional[str] = None
    path: typing.Optional[str] = None
    addon_folder: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="addonFolder")] = None
    installed: typing.Optional[bool] = None
    status: typing.Optional[AddonComponentStatus] = None
    version: typing.Optional[str] = None
    manifest: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    installation_source: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="installationSource")
    ] = None
    unsupported_cluster_types: typing_extensions.Annotated[
        typing.Optional[typing.List[ClusterType]], FieldMetadata(alias="unsupportedClusterTypes")
    ] = None
    required: typing.Optional[bool] = None
    known_cr_ds: typing_extensions.Annotated[typing.Optional[typing.List[str]], FieldMetadata(alias="knownCRDs")] = None
    source: typing.Optional[AddOnComponentSource] = None
    upgrades: typing.Optional[UpgradeData] = None
    labels: typing.Optional[typing.List[str]] = None
    recommendations: typing.Optional[typing.List[Recommendation]] = pydantic.Field(default=None)
    """
    Recommendations
    """

    workspace_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="workspaceId")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


from .i_change import IChange  # noqa: E402, F401, I001

update_forward_refs(AddonComponent)
