# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .ai21integrations import Ai21Integrations
from .ai21key_auth import Ai21KeyAuth
from .collaborator import Collaborator


class Ai21ProviderAccount(UniversalBaseModel):
    """
    +label=AI21
    +icon=ai21
    """

    type: typing.Literal["provider-account/ai21"] = pydantic.Field(default="provider-account/ai21")
    """
    +value=provider-account/ai21
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=100
    +usage=The name of the AI21 provider account
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    auth_data: Ai21KeyAuth
    integrations: typing.Optional[typing.List[Ai21Integrations]] = pydantic.Field(default=None)
    """
    +label=Integrations
    +sort=400
    +usage=List of integrations that are associated with the AI21 provider account
    +uiType=IntegrationsGroup
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    +label=Collaborators
    +sort=200
    +usage=List of users who have access to this provider account
    +uiType=Collaborators
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
