# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AiFeaturesSettings(UniversalBaseModel):
    """
    +docs=Describes the configuration for TrueFoundry AI features
    +label=AI Features Settings
    """

    type: typing.Literal["settings/ai-features"] = pydantic.Field(default="settings/ai-features")
    """
    +value=settings/ai-features
    """

    enabled: bool = pydantic.Field()
    """
    +label=Enabled
    +usage=Enable/Disable AI features.
    Other fields only apply when this is true
    +sort=1
    """

    ai_provider: typing.Literal["truefoundry"] = pydantic.Field(default="truefoundry")
    """
    +label=AI Provider
    +usage=AI provider to use for AI features
    When TrueFoundry is selected, TrueFoundry will manage and provide the AI models for the features.
    +uiProps={"disableEdit":true}
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
