# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .alert_config_resource import AlertConfigResource
from .notification_target_for_alert_rule import NotificationTargetForAlertRule
from .prometheus_alert_rule import PrometheusAlertRule


class AlertConfig(UniversalBaseModel):
    type: typing.Literal["alert-config"] = pydantic.Field(default="alert-config")
    """
    +label=Type
    +value=alert-config
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +message=3 to 35 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"descriptionInline":true}
    +uiType=Hidden
    """

    resource: AlertConfigResource
    notification_targets: typing.List[NotificationTargetForAlertRule] = pydantic.Field()
    """
    +label=Notification Targets
    +usage=Configure one or more notification targets where alerts will be sent. Each target specifies a notification channel (email or slack).
    +uiProps={"descriptionInline":true}
    +sort=1
    """

    rules: typing.List[PrometheusAlertRule] = pydantic.Field()
    """
    +label=Rules
    +usage=Define one or more alert rules that specify the conditions to monitor, when to trigger alerts, and how they should be handled.
    +uiProps={"descriptionInline":true}
    +uiType=Structs
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
