# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AmqpInputConfig(UniversalBaseModel):
    """
    +docs=Describes the configuration for the input AMQP worker
    +label=AMQP
    """

    type: typing.Literal["amqp"] = pydantic.Field(default="amqp")
    """
    +value=amqp
    """

    url: str = pydantic.Field()
    """
    +label=Queue URL
    +usage=AMQP Queue URL of Subscriber
    +sort=1
    """

    queue_name: str = pydantic.Field()
    """
    +label=Queue Name
    +usage=AMQP Queue Name
    +sort=2
    """

    wait_time_seconds: int = pydantic.Field(default=5)
    """
    +label=Wait Time Seconds
    +usage=Wait timeout for long polling.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
