# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AmqpOutputConfig(UniversalBaseModel):
    """
    +docs=Describes the configuration for the output AMQP worker
    +label=AMQP
    """

    type: typing.Literal["amqp"] = pydantic.Field(default="amqp")
    """
    +value=amqp
    """

    url: str = pydantic.Field()
    """
    +label=Queue URL
    +usage=AMQP Queue URL of Publisher
    +sort=1
    """

    routing_key: str = pydantic.Field()
    """
    +label=Routing Key
    +usage=AMQP Routing Key to publish to.
    +sort=2
    """

    exchange_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Exchange Name
    +usage=AMQP Exchange Name
    +sort=3
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
