# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from ..core.serialization import FieldMetadata
from .alert import Alert
from .application_lifecycle_stage import ApplicationLifecycleStage
from .application_metadata import ApplicationMetadata
from .application_problem import ApplicationProblem
from .application_type import ApplicationType
from .recommendation import Recommendation
from .subject import Subject


class Application(UniversalBaseModel):
    id: typing.Optional[str] = None
    fqn: typing.Optional[str] = None
    name: typing.Optional[str] = None
    type: typing.Optional[ApplicationType] = None
    created_by_subject: typing_extensions.Annotated[Subject, FieldMetadata(alias="createdBySubject")]
    tenant_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="tenantName")] = None
    metadata: typing.Optional[ApplicationMetadata] = None
    lifecycle_stage: typing_extensions.Annotated[ApplicationLifecycleStage, FieldMetadata(alias="lifecycleStage")]
    workspace_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="workspaceId")] = None
    last_version: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="lastVersion")] = None
    active_version: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="activeVersion")] = None
    created_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdAt")] = None
    updated_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="updatedAt")] = None
    recommendations: typing.Optional[typing.List[Recommendation]] = pydantic.Field(default=None)
    """
    Recommendations for this application
    """

    alerts: typing.Optional[typing.List[Alert]] = pydantic.Field(default=None)
    """
    Alerts for this application
    """

    alerts_summary: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="alertsSummary")
    ] = pydantic.Field(default=None)
    """
    Summary of alerts for this application
    """

    application_debug_infos: typing_extensions.Annotated[
        typing.Optional[typing.List["ApplicationDebugInfo"]], FieldMetadata(alias="applicationDebugInfos")
    ] = pydantic.Field(default=None)
    """
    Debug infos for this application
    """

    potential_problems: typing_extensions.Annotated[
        typing.Optional[typing.List[ApplicationProblem]], FieldMetadata(alias="potentialProblems")
    ] = pydantic.Field(default=None)
    """
    Potential problems with the application
    """

    autopilot: typing.Dict[str, typing.Optional[typing.Any]]
    workspace_fqn: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="workspaceFqn")] = None
    created_by: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="createdBy")] = None
    deployment: typing.Optional["Deployment"] = None
    active_deployment_id: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="activeDeploymentId")
    ] = None
    last_deployment_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="lastDeploymentId")] = (
        None
    )

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


from .application_debug_info import ApplicationDebugInfo  # noqa: E402, F401, I001
from .deployment import Deployment  # noqa: E402, F401, I001

update_forward_refs(Application)
