# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .application_set_components_item import ApplicationSetComponentsItem


class ApplicationSet(UniversalBaseModel):
    """
    +docs=Describes the configuration for the application set
    """

    type: typing.Literal["application-set"] = pydantic.Field(default="application-set")
    """
    +value=application-set
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +usage=Name of the application set.
    +icon=fa-font
    """

    components: typing.Optional[typing.List[ApplicationSetComponentsItem]] = pydantic.Field(default=None)
    """
    +label=Components
    +usage=Array of components with their specifications.
    +icon=fa-puzzle-piece
    +uiType=AppComponents
    """

    template: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Template
    +usage=Template to be used for the application set.
    +icon=fa-file
    +uiType=Hidden
    """

    values: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    +label=Values
    +usage=Values to be used to render components for the application set.
    +icon=fa-file
    +uiType=YamlInput
    +uiProps={"allowAllValues":true}
    """

    workspace_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Workspace FQN
    +docs=Fully qualified name of the workspace
    +uiType=Hidden
    """

    convert_template_manifest: typing.Optional[bool] = pydantic.Field(default=None)
    """
    +label=Convert Template Manifest
    +docs=Flag to indicate if the template manifest should be converted to TrueFoundry manifest
    +uiType=Hidden
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
