# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ApplicationType(str, enum.Enum):
    ASYNC_SERVICE = "async-service"
    SERVICE = "service"
    JOB = "job"
    SPARK_JOB = "spark-job"
    HELM = "helm"
    NOTEBOOK = "notebook"
    CODESERVER = "codeserver"
    RSTUDIO = "rstudio"
    SSH_SERVER = "ssh-server"
    VOLUME = "volume"
    APPLICATION = "application"
    APPLICATION_SET = "application-set"
    INTERCEPT = "intercept"
    WORKFLOW = "workflow"

    def visit(
        self,
        async_service: typing.Callable[[], T_Result],
        service: typing.Callable[[], T_Result],
        job: typing.Callable[[], T_Result],
        spark_job: typing.Callable[[], T_Result],
        helm: typing.Callable[[], T_Result],
        notebook: typing.Callable[[], T_Result],
        codeserver: typing.Callable[[], T_Result],
        rstudio: typing.Callable[[], T_Result],
        ssh_server: typing.Callable[[], T_Result],
        volume: typing.Callable[[], T_Result],
        application: typing.Callable[[], T_Result],
        application_set: typing.Callable[[], T_Result],
        intercept: typing.Callable[[], T_Result],
        workflow: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ApplicationType.ASYNC_SERVICE:
            return async_service()
        if self is ApplicationType.SERVICE:
            return service()
        if self is ApplicationType.JOB:
            return job()
        if self is ApplicationType.SPARK_JOB:
            return spark_job()
        if self is ApplicationType.HELM:
            return helm()
        if self is ApplicationType.NOTEBOOK:
            return notebook()
        if self is ApplicationType.CODESERVER:
            return codeserver()
        if self is ApplicationType.RSTUDIO:
            return rstudio()
        if self is ApplicationType.SSH_SERVER:
            return ssh_server()
        if self is ApplicationType.VOLUME:
            return volume()
        if self is ApplicationType.APPLICATION:
            return application()
        if self is ApplicationType.APPLICATION_SET:
            return application_set()
        if self is ApplicationType.INTERCEPT:
            return intercept()
        if self is ApplicationType.WORKFLOW:
            return workflow()
