# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from .async_processor_sidecar import AsyncProcessorSidecar
from .async_service_replicas import AsyncServiceReplicas
from .base_service import BaseService
from .rolling import Rolling
from .worker_config import WorkerConfig


class AsyncService(BaseService):
    """
    +docs=Describes the configuration for the async-service
    """

    type: typing.Literal["async-service"] = pydantic.Field(default="async-service")
    """
    +value=async-service
    """

    replicas: AsyncServiceReplicas = pydantic.Field()
    """
    +label=Replicas
    +usage=Deploy multiple instances of your pods to distribute incoming traffic across them, ensuring effective load balancing.
    +icon=fa-clone
    """

    rollout_strategy: typing.Optional[Rolling] = None
    worker_config: WorkerConfig
    sidecar: typing.Optional[AsyncProcessorSidecar] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
