# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aws_bedrock_guardrail_config_auth_data import AwsBedrockGuardrailConfigAuthData
from .aws_bedrock_guardrail_config_operation import AwsBedrockGuardrailConfigOperation
from .aws_region import AwsRegion


class AwsBedrockGuardrailConfig(UniversalBaseModel):
    """
    +label=AWS Bedrock
    +icon=aws-bedrock
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=50
    +usage=The name of the Guardrail Config.
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    type: typing.Literal["integration/guardrail-config/aws-bedrock"] = pydantic.Field(
        default="integration/guardrail-config/aws-bedrock"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/aws-bedrock
    """

    operation: AwsBedrockGuardrailConfigOperation = pydantic.Field()
    """
    +label=Operation
    +usage=The operation type to use for the Guardrail. Validate guardrails are used to validate requests and mutate can validate as well as mutate requests.
    Validate guardrails are run in parallel while mutate guardrails are run sequentially.
    +uiType=Select
    +sort=50
    """

    auth_data: typing.Optional[AwsBedrockGuardrailConfigAuthData] = pydantic.Field(default=None)
    """
    +label=AWS Account Auth Data
    +usage=Authentication data for the AWS account
    """

    guardrail_id: str = pydantic.Field()
    """
    +label=Guardrail ID
    +usage=The ID of the Guardrail to use.
    """

    guardrail_version: str = pydantic.Field()
    """
    +label=Guardrail Version
    +usage=The version of the Guardrail to use.
    """

    region: AwsRegion

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
