# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aws_bedrock_provider_account_auth_data import AwsBedrockProviderAccountAuthData
from .aws_region import AwsRegion
from .bedrock_model_v2 import BedrockModelV2
from .collaborator import Collaborator


class AwsBedrockProviderAccount(UniversalBaseModel):
    """
    +label=AWS Bedrock
    +icon=aws
    """

    type: typing.Literal["provider-account/aws-bedrock"] = pydantic.Field(default="provider-account/aws-bedrock")
    """
    +value=provider-account/aws-bedrock
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=100
    +usage=The name of the AWS Bedrock provider account
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    region: AwsRegion
    auth_data: typing.Optional[AwsBedrockProviderAccountAuthData] = pydantic.Field(default=None)
    """
    +label=AWS Account Auth Data
    +sort=400
    +usage=Authentication data for the AWS account
    """

    integrations: typing.List[BedrockModelV2] = pydantic.Field()
    """
    +label=Integrations
    +sort=500
    +usage=List of integrations that are associated with the AWS Bedrock provider account
    +uiType=IntegrationsGroup
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    +label=Collaborators
    +sort=600
    +usage=List of users who have access to this provider account
    +uiType=Collaborators
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
