# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aws_ecr_auth_data import AwsEcrAuthData


class AwsEcr(UniversalBaseModel):
    """
    +label=AWS ECR
    +icon=aws-ecr
    """

    type: typing.Literal["integration/docker-registry/aws/ecr"] = pydantic.Field(
        default="integration/docker-registry/aws/ecr"
    )
    """
    +value=integration/docker-registry/aws/ecr
    """

    name: str = pydantic.Field()
    """
    +label=Display Name
    +usage=The name of the integration that will be displayed in the TrueFoundry UI.
    +sort=100
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    registry_url: str = pydantic.Field()
    """
    +label=Registry URL
    +usage=The URL of the registry.
    +sort=200
    """

    auth_data: typing.Optional[AwsEcrAuthData] = pydantic.Field(default=None)
    """
    +label=Auth Data
    +usage=Custom authentication data for the integration.
    +sort=300
    """

    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +sort=600
    +uiType=AuthorizedSubjects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
