# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aws_integrations import AwsIntegrations
from .aws_provider_account_auth_data import AwsProviderAccountAuthData


class AwsProviderAccount(UniversalBaseModel):
    """
    +label=AWS
    +icon=aws
    +heroDataKey=aws_account_id
    """

    type: typing.Literal["provider-account/aws"] = pydantic.Field(default="provider-account/aws")
    """
    +value=provider-account/aws
    """

    name: str = pydantic.Field()
    """
    +uiProps={"disableEdit":true}
    +label=Name
    +usage=The name of the AWS provider account.
    +sort=200
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    aws_account_id: str = pydantic.Field()
    """
    +label=AWS Account ID
    +usage=The AWS account ID.
    +sort=300
    """

    auth_data: typing.Optional[AwsProviderAccountAuthData] = pydantic.Field(default=None)
    """
    +label=AWS Account Auth Data
    +usage=Authentication data for the AWS account.
    +sort=400
    """

    integrations: typing.List[AwsIntegrations] = pydantic.Field()
    """
    +label=Integrations
    +usage=List of integrations that are associated with the AWS provider account.
    +sort=500
    +uiType=IntegrationsGroup
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
