# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aws_region import AwsRegion
from .aws_sagemaker_provider_account_auth_data import AwsSagemakerProviderAccountAuthData
from .collaborator import Collaborator
from .sagemaker_model import SagemakerModel


class AwsSagemakerProviderAccount(UniversalBaseModel):
    """
    +label=Sagemaker
    +icon=aws
    """

    type: typing.Literal["provider-account/aws-sagemaker"] = pydantic.Field(default="provider-account/aws-sagemaker")
    """
    +value=provider-account/aws-sagemaker
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=100
    +usage=The name of the Sagemaker provider account
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    region: AwsRegion
    auth_data: typing.Optional[AwsSagemakerProviderAccountAuthData] = pydantic.Field(default=None)
    """
    +label=AWS Account Auth Data
    +sort=400
    +usage=Authentication data for the AWS account
    """

    integrations: typing.List[SagemakerModel] = pydantic.Field()
    """
    +label=Integrations
    +sort=500
    +usage=List of integrations that are associated with the Sagemaker provider account
    +uiType=IntegrationsGroup
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    +label=Collaborators
    +sort=600
    +usage=List of users who have access to this provider account
    +uiType=Collaborators
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
