# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aws_region import AwsRegion
from .aws_secrets_manager_auth_data import AwsSecretsManagerAuthData


class AwsSecretsManager(UniversalBaseModel):
    """
    +label=AWS Secrets Manager
    +icon=aws-secrets-manager
    """

    type: typing.Literal["integration/secret-store/aws/secrets-manager"] = pydantic.Field(
        default="integration/secret-store/aws/secrets-manager"
    )
    """
    +value=integration/secret-store/aws/secrets-manager
    """

    name: str = pydantic.Field()
    """
    +label=Display Name
    +usage=The name of the integration that will be displayed in the TrueFoundry UI.
    +sort=150
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    region: AwsRegion
    auth_data: typing.Optional[AwsSecretsManagerAuthData] = pydantic.Field(default=None)
    """
    +label=Auth Data
    +usage=Custom authentication data for the integration.
    +sort=300
    """

    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +sort=600
    +uiType=AuthorizedSubjects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
