# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .azure_ai_inference_model_deployment_details import AzureAiInferenceModelDeploymentDetails
from .azure_key_auth import AzureKeyAuth
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class AzureAiInferenceModel(UniversalBaseModel):
    """
    +label=Azure AI Inference Model
    """

    name: str = pydantic.Field()
    """
    +label=Display Name
    +usage=Name to identify this Azure AI model
    +sort=100
    +message=2 to 62 characters long alphanumeric word, may contain - or . in between, cannot start with a number
    """

    type: typing.Literal["integration/model/azure/ai-inference"] = pydantic.Field(
        default="integration/model/azure/ai-inference"
    )
    """
    +value=integration/model/azure/ai-inference
    """

    model_types: typing.List[ModelType] = pydantic.Field()
    """
    +label=Model Types
    +usage=Types of models supported by this Azure AI deployment
    +sort=200
    """

    auth_data: typing.Optional[AzureKeyAuth] = None
    deployment_details: typing_extensions.Annotated[
        AzureAiInferenceModelDeploymentDetails, FieldMetadata(alias="deploymentDetails")
    ] = pydantic.Field()
    """
    +label=Deployment Configuration
    +usage=Configuration details for the Azure AI deployment
    +sort=400
    """

    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +uiType=Hidden
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
