# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class AzureAiManagedDeployment(UniversalBaseModel):
    """
    +label=Azure AI Managed Deployment
    """

    type: typing.Literal["managed"] = pydantic.Field(default="managed")
    """
    +value=managed
    """

    deployment_name: typing_extensions.Annotated[str, FieldMetadata(alias="deploymentName")] = pydantic.Field()
    """
    +label=Azure Deployment Name
    +usage=Name of the Azure AI deployment
    +sort=1
    """

    endpoint_name: typing_extensions.Annotated[str, FieldMetadata(alias="endpointName")] = pydantic.Field()
    """
    +label=Azure Endpoint Name
    +usage=Name of the Azure AI endpoint
    +sort=2
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
