# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .azure_o_auth import AzureOAuth


class AzureAksIntegration(UniversalBaseModel):
    """
    +icon=azure-aks
    +label=Azure AKS
    """

    type: typing.Literal["integration/cluster/azure/aks"] = pydantic.Field(default="integration/cluster/azure/aks")
    """
    +value=integration/cluster/azure/aks
    """

    name: str = pydantic.Field()
    """
    +label=Display Name
    +usage=The name of the integration that will be displayed in the TrueFoundry UI.
    +sort=100
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    resource_group: str = pydantic.Field()
    """
    +label=Resource Group
    +usage=The resource group of the cluster in the cloud account.
    +sort=200
    """

    cluster_name: str = pydantic.Field()
    """
    +label=Cluster Name
    +usage=Name of the cluster given in the cloud account.
    +sort=300
    """

    auth_data: typing.Optional[AzureOAuth] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +sort=600
    +uiType=AuthorizedSubjects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
