# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .azure_content_safety_category import AzureContentSafetyCategory
from .azure_key_auth import AzureKeyAuth


class AzureContentSafetyGuardrailConfig(UniversalBaseModel):
    """
    +label=Azure Content Safety
    +icon=azure
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=50
    +usage=The name of the Guardrail Config.
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    type: typing.Literal["integration/guardrail-config/azure-content-safety"] = pydantic.Field(
        default="integration/guardrail-config/azure-content-safety"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/azure-content-safety
    """

    resource_name: str = pydantic.Field()
    """
    +label=Resource Name
    +usage=The resource name where API is deployed.
    +sort=100
    """

    api_version: str = pydantic.Field(default="2024-09-01")
    """
    +label=API Version
    +usage=API version for the Content Safety API
    +sort=200
    """

    custom_host: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Custom Host
    +usage=Custom host for the PII detection API
    +sort=300
    +uiType=Hidden
    """

    blocklist_names: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Blocklist Names
    +usage=Array of blocklist names to check against
    +sort=400
    """

    severity_threshold: float = pydantic.Field(default=2.0)
    """
    +label=Severity
    +usage=Severity threshold for the Content Safety API
    +sort=500
    """

    categories: typing.List[AzureContentSafetyCategory] = pydantic.Field()
    """
    +label=Categories
    +usage=Categories to check against
    +uiType=Select
    +sort=600
    """

    auth_data: AzureKeyAuth

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
